/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.EndSpikeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class EndSpikeFeature
extends Feature<EndSpikeFeatureConfig> {
    private static final LoadingCache<Long, List<EndSpike>> field_214555_a = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new EndSpikeCacheLoader());

    public EndSpikeFeature(Function<Dynamic<?>, ? extends EndSpikeFeatureConfig> function) {
        super(function);
    }

    public static List<EndSpike> func_214554_a(IWorld iWorld) {
        Random random = new Random(iWorld.func_72905_C());
        long \u26032 = random.nextLong() & 0xFFFFL;
        return (List)field_214555_a.getUnchecked((Object)\u26032);
    }

    @Override
    public boolean func_212245_a(IWorld iWorld, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos, EndSpikeFeatureConfig endSpikeFeatureConfig) {
        List<EndSpike> list = endSpikeFeatureConfig.func_214671_b();
        if (list.isEmpty()) {
            list = EndSpikeFeature.func_214554_a(iWorld);
        }
        for (EndSpike endSpike : list) {
            if (!endSpike.func_186154_a(blockPos)) continue;
            this.func_214553_a(iWorld, random, endSpikeFeatureConfig, endSpike);
        }
        return true;
    }

    private void func_214553_a(IWorld iWorld, Random random, EndSpikeFeatureConfig endSpikeFeatureConfig, EndSpike endSpike2) {
        EndSpike endSpike2;
        int n = endSpike2.func_186148_c();
        for (BlockPos blockPos : BlockPos.func_218278_a(new BlockPos(endSpike2.func_186151_a() - n, 0, endSpike2.func_186152_b() - n), new BlockPos(endSpike2.func_186151_a() + n, endSpike2.func_186149_d() + 10, endSpike2.func_186152_b() + n))) {
            if (blockPos.func_218140_a(endSpike2.func_186151_a(), blockPos.func_177956_o(), endSpike2.func_186152_b(), false) <= (double)(n * n + 1) && blockPos.func_177956_o() < endSpike2.func_186149_d()) {
                this.func_202278_a(iWorld, blockPos, Blocks.field_150343_Z.func_176223_P());
                continue;
            }
            if (blockPos.func_177956_o() <= 65) continue;
            this.func_202278_a(iWorld, blockPos, Blocks.field_150350_a.func_176223_P());
        }
        if (endSpike2.func_186150_e()) {
            int n2 = -2;
            \u2603 = 2;
            \u2603 = 3;
            BlockPos.Mutable \u26032 = new BlockPos.Mutable();
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                    for (\u2603 = 0; \u2603 <= 3; ++\u2603) {
                        boolean bl = MathHelper.func_76130_a(\u2603) == 2;
                        \u2603 = MathHelper.func_76130_a(\u2603) == 2;
                        boolean bl2 = \u2603 = \u2603 == 3;
                        if (!bl && !\u2603 && !\u2603) continue;
                        \u2603 = \u2603 == -2 || \u2603 == 2 || \u2603;
                        \u2603 = \u2603 == -2 || \u2603 == 2 || \u2603;
                        BlockState \u26033 = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(PaneBlock.field_196409_a, \u2603 && \u2603 != -2)).func_206870_a(PaneBlock.field_196413_c, \u2603 && \u2603 != 2)).func_206870_a(PaneBlock.field_196414_y, \u2603 && \u2603 != -2)).func_206870_a(PaneBlock.field_196411_b, \u2603 && \u2603 != 2);
                        this.func_202278_a(iWorld, \u26032.func_181079_c(endSpike2.func_186151_a() + \u2603, endSpike2.func_186149_d() + \u2603, endSpike2.func_186152_b() + \u2603), \u26033);
                    }
                }
            }
        }
        EnderCrystalEntity enderCrystalEntity = EntityType.field_200801_o.func_200721_a(iWorld.func_201672_e());
        enderCrystalEntity.func_184516_a(endSpikeFeatureConfig.func_214668_c());
        enderCrystalEntity.func_184224_h(endSpikeFeatureConfig.func_214669_a());
        enderCrystalEntity.func_70012_b((float)endSpike2.func_186151_a() + 0.5f, endSpike2.func_186149_d() + 1, (float)endSpike2.func_186152_b() + 0.5f, random.nextFloat() * 360.0f, 0.0f);
        iWorld.func_217376_c(enderCrystalEntity);
        this.func_202278_a(iWorld, new BlockPos(endSpike2.func_186151_a(), endSpike2.func_186149_d(), endSpike2.func_186152_b()), Blocks.field_150357_h.func_176223_P());
    }

    static class EndSpikeCacheLoader
    extends CacheLoader<Long, List<EndSpike>> {
        private EndSpikeCacheLoader() {
        }

        public List<EndSpike> load(Long l) {
            List list = IntStream.range(0, 10).boxed().collect(Collectors.toList());
            Collections.shuffle(list, new Random(l));
            ArrayList \u26032 = Lists.newArrayList();
            for (int i = 0; i < 10; ++i) {
                \u2603 = MathHelper.func_76128_c(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                \u2603 = MathHelper.func_76128_c(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i)));
                \u2603 = (Integer)list.get(i);
                \u2603 = 2 + \u2603 / 3;
                \u2603 = 76 + \u2603 * 3;
                boolean bl = \u2603 == 1 || \u2603 == 2;
                \u26032.add(new EndSpike(\u2603, \u2603, \u2603, \u2603, bl));
            }
            return \u26032;
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((Long)object);
        }
    }

    public static class EndSpike {
        private final int field_186155_a;
        private final int field_186156_b;
        private final int field_186157_c;
        private final int field_186158_d;
        private final boolean field_186159_e;
        private final AxisAlignedBB field_186160_f;

        public EndSpike(int n, int n2, int n3, int n4, boolean bl) {
            this.field_186155_a = n;
            this.field_186156_b = n2;
            this.field_186157_c = n3;
            this.field_186158_d = n4;
            this.field_186159_e = bl;
            this.field_186160_f = new AxisAlignedBB(n - n3, 0.0, n2 - n3, n + n3, 256.0, n2 + n3);
        }

        public boolean func_186154_a(BlockPos blockPos) {
            return blockPos.func_177958_n() >> 4 == this.field_186155_a >> 4 && blockPos.func_177952_p() >> 4 == this.field_186156_b >> 4;
        }

        public int func_186151_a() {
            return this.field_186155_a;
        }

        public int func_186152_b() {
            return this.field_186156_b;
        }

        public int func_186148_c() {
            return this.field_186157_c;
        }

        public int func_186149_d() {
            return this.field_186158_d;
        }

        public boolean func_186150_e() {
            return this.field_186159_e;
        }

        public AxisAlignedBB func_186153_f() {
            return this.field_186160_f;
        }

        public <T> Dynamic<T> func_214749_a(DynamicOps<T> dynamicOps) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put(dynamicOps.createString("centerX"), dynamicOps.createInt(this.field_186155_a));
            builder.put(dynamicOps.createString("centerZ"), dynamicOps.createInt(this.field_186156_b));
            builder.put(dynamicOps.createString("radius"), dynamicOps.createInt(this.field_186157_c));
            builder.put(dynamicOps.createString("height"), dynamicOps.createInt(this.field_186158_d));
            builder.put(dynamicOps.createString("guarded"), dynamicOps.createBoolean(this.field_186159_e));
            return new Dynamic(dynamicOps, dynamicOps.createMap((Map)builder.build()));
        }

        public static <T> EndSpike func_214747_a(Dynamic<T> dynamic) {
            return new EndSpike(dynamic.get("centerX").asInt(0), dynamic.get("centerZ").asInt(0), dynamic.get("radius").asInt(0), dynamic.get("height").asInt(0), dynamic.get("guarded").asBoolean(false));
        }
    }
}

