/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    private static ForgeConfigSpec.BooleanValue LOGSPAM;
    private static ForgeConfigSpec.IntValue REFRESHTICKS;
    private static ForgeConfigSpec.BooleanValue RELOADONCHUNK;
    private static ForgeConfigSpec.ConfigValue<List<String>> BLACKLIST;

    private static void initConfig() {
        COMMON_BUILDER.comment("General settings").push("storagenetwork");
        LOGSPAM = COMMON_BUILDER.comment("Enable very spammy logs.  Sometimes useful for debugging. ").define("logSpam", false);
        RELOADONCHUNK = COMMON_BUILDER.comment("If this is true, reload network when a chunk unloads, this keeps your network always up to date.  It has been reported that this cause lag and chunk load issues on servers, so disable if you have any problems. ").define("reloadNetworkWhenUnloadChunk", false);
        REFRESHTICKS = COMMON_BUILDER.comment("How often to auto-refresh a network (one second is 20 ticks)").defineInRange("autoRefreshTicks", 20, 2, 4096);
        ArrayList<String> list = new ArrayList<String>();
        list.add("extrautils2:playerchest");
        BLACKLIST = COMMON_BUILDER.comment("Disable these blocks from ever being able to connect to the network, they will be treated as a non-inventory.").define("BlacklistBlocks", list);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public ConfigManager(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public boolean logspam() {
        return (Boolean)LOGSPAM.get();
    }

    public boolean doReloadOnChunk() {
        return (Boolean)RELOADONCHUNK.get();
    }

    public int refreshTicks() {
        return (Integer)REFRESHTICKS.get();
    }

    public List<String> blacklist() {
        return (List)BLACKLIST.get();
    }

    static {
        ConfigManager.initConfig();
    }
}

