/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.data.DimPos;
import com.lothrazar.storagenetwork.api.util.UtilTileEntity;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import com.lothrazar.storagenetwork.capabilities.CapabilityConnectable;
import com.lothrazar.storagenetwork.capabilities.StorageNetworkCapabilities;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileConnectable
extends TileEntity {
    private final CapabilityConnectable connectable = new CapabilityConnectable();

    public TileConnectable(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.connectable.setPos(new DimPos(this.field_145850_b, this.field_174879_c));
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("connectable")) {
            this.connectable.deserializeNBT(compound.func_74775_l("connectable"));
        }
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("connectable", (INBT)this.connectable.serializeNBT());
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT syncData = new CompoundNBT();
        this.func_189515_b(syncData);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, syncData);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (StorageNetwork.config.doReloadOnChunk() && this.connectable != null && this.connectable.getMasterPos() != null) {
            try {
                TileMaster maybeMaster = UtilTileEntity.getTileMasterForConnectable(this.connectable);
                if (maybeMaster != null) {
                    maybeMaster.refreshNetwork();
                }
            }
            catch (Exception e) {
                StorageNetwork.LOGGER.info("Error on chunk unload " + e);
            }
        }
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_CAPABILITY) {
            LazyOptional cap = LazyOptional.of(() -> this.connectable);
            return cap;
        }
        return super.getCapability(capability, facing);
    }

    public DimPos getMaster() {
        return this.connectable.getMasterPos();
    }
}

