/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import de.ellpeck.prettypipes.misc.ItemTerminalWidget;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketRequest;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ItemTerminalGui
extends ContainerScreen<ItemTerminalContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/item_terminal.png");
    private List<ItemStack> items;
    private List<ItemStack> sortedItems;
    private Button minusButton;
    private Button plusButton;
    private Button requestButton;
    private Button orderButton;
    private Button ascendingButton;
    private String lastSearchText;
    private int requestAmount = 1;
    private int scrollOffset;
    public TextFieldWidget search;

    public ItemTerminalGui(ItemTerminalContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 191;
        this.field_147000_g = 236;
    }

    protected void init() {
        super.init();
        this.plusButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + this.getXOffset() + 95 - 7 + 12, this.field_147009_r + 103, 12, 12, "+", button -> {
            int modifier = ItemTerminalGui.requestModifier();
            this.requestAmount = modifier > 1 && this.requestAmount == 1 ? modifier : (this.requestAmount += modifier);
            if (this.requestAmount > 384) {
                this.requestAmount = 384;
            }
        }));
        this.minusButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + this.getXOffset() + 95 - 7 - 24, this.field_147009_r + 103, 12, 12, "-", button -> {
            this.requestAmount -= ItemTerminalGui.requestModifier();
            if (this.requestAmount < 1) {
                this.requestAmount = 1;
            }
        }));
        this.minusButton.active = false;
        this.requestButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + this.getXOffset() + 95 - 7 - 25, this.field_147009_r + 115, 50, 20, I18n.func_135052_a((String)"info.prettypipes.request", (Object[])new Object[0]), button -> {
            Optional<ItemTerminalWidget> widget = this.streamWidgets().filter(w -> w.selected).findFirst();
            if (!widget.isPresent()) {
                return;
            }
            ItemStack stack = widget.get().stack.func_77946_l();
            stack.func_190920_e(1);
            PacketHandler.sendToServer(new PacketRequest(((ItemTerminalContainer)this.field_147002_h).tile.func_174877_v(), stack, this.requestAmount));
            this.requestAmount = 1;
        }));
        this.requestButton.active = false;
        this.orderButton = (Button)this.addButton((Widget)new Button(this.field_147003_i - 22, this.field_147009_r, 20, 20, "", button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalItemOrder = prefs.terminalItemOrder.next();
            prefs.save();
            this.updateWidgets();
        }));
        this.ascendingButton = (Button)this.addButton((Widget)new Button(this.field_147003_i - 22, this.field_147009_r + 22, 20, 20, "", button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalAscending = !prefs.terminalAscending;
            prefs.save();
            this.updateWidgets();
        }));
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addButton(new ItemTerminalWidget(this.field_147003_i + this.getXOffset() + 8 + x * 18, this.field_147009_r + 18 + y * 18, x, y, this));
            }
        }
        this.search = (TextFieldWidget)this.addButton((Widget)new TextFieldWidget(this.font, this.field_147003_i + this.getXOffset() + 97, this.field_147009_r + 6, 86, 8, ""));
        this.search.func_146185_a(false);
        this.lastSearchText = "";
        if (this.items != null) {
            this.updateWidgets();
        }
    }

    protected int getXOffset() {
        return 0;
    }

    public void tick() {
        super.tick();
        this.requestButton.active = this.streamWidgets().anyMatch(w -> w.selected);
        this.plusButton.active = this.requestAmount < 384;
        this.minusButton.active = this.requestAmount > 1;
        this.search.func_146178_a();
        String text = this.search.func_146179_b();
        if (!this.lastSearchText.equals(text)) {
            this.lastSearchText = text;
            this.updateWidgets();
        }
    }

    public boolean keyPressed(int x, int y, int z) {
        InputMappings.Input mouseKey;
        if (this.search.isFocused() && this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey = InputMappings.func_197954_a((int)x, (int)y))) {
            return false;
        }
        return super.keyPressed(x, y, z);
    }

    public void updateItemList(List<ItemStack> items) {
        this.items = items;
        this.updateWidgets();
    }

    public void updateWidgets() {
        PlayerPrefs prefs = PlayerPrefs.get();
        this.ascendingButton.setMessage(prefs.terminalAscending ? "^" : "v");
        this.orderButton.setMessage(prefs.terminalItemOrder.name().substring(0, 1));
        Comparator<ItemStack> comparator = prefs.terminalItemOrder.comparator;
        if (!prefs.terminalAscending) {
            comparator = comparator.reversed();
        }
        this.sortedItems = new ArrayList<ItemStack>(this.items);
        this.sortedItems.sort(comparator);
        String searchText = this.search.func_146179_b();
        if (!Strings.isNullOrEmpty((String)searchText)) {
            this.sortedItems.removeIf(s -> {
                String toCompare;
                String search = searchText;
                if (search.startsWith("@")) {
                    toCompare = s.func_77973_b().getRegistryName().func_110624_b();
                    search = search.substring(1);
                } else {
                    toCompare = s.func_200301_q().getString();
                }
                return !toCompare.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT));
            });
        }
        if (this.sortedItems.size() < 36) {
            this.scrollOffset = 0;
        }
        List widgets = this.streamWidgets().collect(Collectors.toList());
        for (int i = 0; i < widgets.size(); ++i) {
            ItemTerminalWidget widget = (ItemTerminalWidget)((Object)widgets.get(i));
            int index = i + this.scrollOffset * 9;
            if (index >= this.sortedItems.size()) {
                widget.stack = ItemStack.field_190927_a;
                widget.visible = false;
                continue;
            }
            widget.stack = this.sortedItems.get(index);
            widget.visible = true;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        for (Widget widget : this.buttons) {
            if (!(widget instanceof ItemTerminalWidget)) continue;
            widget.renderToolTip(mouseX, mouseY);
        }
        if (this.sortedItems != null) {
            PlayerPrefs prefs = PlayerPrefs.get();
            if (this.orderButton.isHovered()) {
                this.renderTooltip(I18n.func_135052_a((String)"info.prettypipes.order", (Object[])new Object[]{I18n.func_135052_a((String)("info.prettypipes.order." + prefs.terminalItemOrder.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0])}), mouseX, mouseY);
            }
            if (this.ascendingButton.isHovered()) {
                this.renderTooltip(I18n.func_135052_a((String)("info.prettypipes." + (prefs.terminalAscending ? "ascending" : "descending")), (Object[])new Object[0]), mouseX, mouseY);
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), (float)(8 + this.getXOffset()), (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        String amount = String.valueOf(this.requestAmount);
        this.font.func_211126_b(amount, (float)(191 - this.font.func_78256_a(amount)) / 2.0f - 7.0f + (float)this.getXOffset(), 106.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.getMinecraft().func_110434_K().func_110577_a(this.getTexture());
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.sortedItems != null && this.sortedItems.size() >= 36) {
            float percentage = (float)this.scrollOffset / (float)(this.sortedItems.size() / 9 - 3);
            this.blit(this.field_147003_i + this.getXOffset() + 172, this.field_147009_r + 18 + (int)(percentage * 55.0f), 232, 241, 12, 15);
        } else {
            this.blit(this.field_147003_i + this.getXOffset() + 172, this.field_147009_r + 18, 244, 241, 12, 15);
        }
    }

    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        int offset;
        if (this.sortedItems != null && this.sortedItems.size() >= 36 && (offset = MathHelper.func_76125_a((int)(this.scrollOffset - (int)Math.signum(scroll)), (int)0, (int)(this.sortedItems.size() / 9 - 3))) != this.scrollOffset) {
            this.scrollOffset = offset;
            this.updateWidgets();
        }
        return true;
    }

    public Stream<ItemTerminalWidget> streamWidgets() {
        return this.buttons.stream().filter(w -> w instanceof ItemTerminalWidget).map(w -> (ItemTerminalWidget)((Object)w));
    }

    private static int requestModifier() {
        if (ItemTerminalGui.hasControlDown()) {
            return 10;
        }
        if (ItemTerminalGui.hasShiftDown()) {
            return 64;
        }
        return 1;
    }
}

