/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;

public class NetworkLocation
implements INBTSerializable<CompoundNBT> {
    public BlockPos pipePos;
    public Direction direction;
    private Map<Integer, ItemStack> itemCache;
    private IItemHandler handlerCache;

    public NetworkLocation(BlockPos pipePos, Direction direction) {
        this.pipePos = pipePos;
        this.direction = direction;
    }

    public NetworkLocation(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public List<Integer> getStackSlots(World world, ItemStack stack, ItemEqualityType ... equalityTypes) {
        if (this.isEmpty(world)) {
            return Collections.emptyList();
        }
        return this.getItems(world).entrySet().stream().filter(e -> ItemEqualityType.compareItems((ItemStack)e.getValue(), stack, equalityTypes)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int getItemAmount(World world, ItemStack stack, ItemEqualityType ... equalityTypes) {
        if (this.isEmpty(world)) {
            return 0;
        }
        return this.getItems(world).values().stream().filter(i -> ItemEqualityType.compareItems(stack, i, equalityTypes)).mapToInt(ItemStack::func_190916_E).sum();
    }

    public Map<Integer, ItemStack> getItems(World world) {
        IItemHandler handler;
        if (this.itemCache == null && (handler = this.getItemHandler(world)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack found = handler.extractItem(i, Integer.MAX_VALUE, true);
                if (found.func_190926_b()) continue;
                if (this.itemCache == null) {
                    this.itemCache = new HashMap<Integer, ItemStack>();
                }
                this.itemCache.put(i, found);
            }
        }
        return this.itemCache;
    }

    public IItemHandler getItemHandler(World world) {
        if (this.handlerCache == null) {
            PipeNetwork network = PipeNetwork.get(world);
            PipeTileEntity pipe = network.getPipe(this.pipePos);
            this.handlerCache = pipe.getItemHandler(this.direction, null);
        }
        return this.handlerCache;
    }

    public boolean isEmpty(World world) {
        Map<Integer, ItemStack> items = this.getItems(world);
        return items == null || items.isEmpty();
    }

    public BlockPos getPos() {
        return this.pipePos.func_177972_a(this.direction);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("pipe_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pipePos));
        nbt.func_74768_a("direction", this.direction.func_176745_a());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.pipePos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pipe_pos"));
        this.direction = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
    }
}

