/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.render;

import com.raoulvdberge.refinedpipes.block.PipeBlock;
import com.raoulvdberge.refinedpipes.render.PipeState;
import com.raoulvdberge.refinedpipes.render.TrsrBakedModel;
import com.raoulvdberge.refinedpipes.tile.PipeTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PipeBakedModel
implements IBakedModel {
    private final IBakedModel core;
    private final IBakedModel extension;
    private final IBakedModel straight;
    private final Map<ResourceLocation, Map<Direction, IBakedModel>> attachmentModels = new HashMap<ResourceLocation, Map<Direction, IBakedModel>>();
    private final Map<Direction, IBakedModel> inventoryAttachmentModels = new HashMap<Direction, IBakedModel>();
    private final Map<PipeState, List<BakedQuad>> cache = new HashMap<PipeState, List<BakedQuad>>();

    public PipeBakedModel(IBakedModel core, IBakedModel extension, IBakedModel straight, IBakedModel inventoryAttachment, Map<ResourceLocation, IBakedModel> attachmentModels) {
        this.core = core;
        this.extension = extension;
        this.straight = straight;
        for (Map.Entry<ResourceLocation, IBakedModel> entry : attachmentModels.entrySet()) {
            HashMap<Direction, TrsrBakedModel> dirToModel = new HashMap<Direction, TrsrBakedModel>();
            for (Direction dir : Direction.values()) {
                dirToModel.put(dir, new TrsrBakedModel(entry.getValue(), dir));
            }
            this.attachmentModels.put(entry.getKey(), dirToModel);
        }
        for (Direction direction : Direction.values()) {
            this.inventoryAttachmentModels.put(direction, new TrsrBakedModel(inventoryAttachment, direction));
        }
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        PipeState pipeState = new PipeState(state, (ResourceLocation[])extraData.getData(PipeTileEntity.ATTACHMENTS_PROPERTY), side, rand);
        return this.cache.computeIfAbsent(pipeState, this::createQuads);
    }

    private List<BakedQuad> createQuads(PipeState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state.getState() != null) {
            boolean north = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.NORTH);
            int east = ((Boolean)state.getState().func_177229_b((IProperty)PipeBlock.EAST)).booleanValue() ? 1 : 0;
            int south = ((Boolean)state.getState().func_177229_b((IProperty)PipeBlock.SOUTH)).booleanValue() ? 1 : 0;
            boolean west = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.WEST);
            boolean up = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.UP);
            boolean down = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.DOWN);
            if (north && south != 0 && east == 0 && !west && !up && !down) {
                quads.addAll(this.straight.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else if (!north && south == 0 && east != 0 && west && !up && !down) {
                quads.addAll(new TrsrBakedModel(this.straight, Direction.EAST).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else if (!north && south == 0 && east == 0 && !west && up && down) {
                quads.addAll(new TrsrBakedModel(this.straight, Direction.UP).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else if (!(north || south != 0 || east != 0 || west || up || down)) {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            } else {
                quads.addAll(this.core.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                if (north) {
                    quads.addAll(this.extension.getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (east != 0) {
                    quads.addAll(new TrsrBakedModel(this.extension, Direction.EAST).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (south != 0) {
                    quads.addAll(new TrsrBakedModel(this.extension, Direction.SOUTH).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (west) {
                    quads.addAll(new TrsrBakedModel(this.extension, Direction.WEST).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (up) {
                    quads.addAll(new TrsrBakedModel(this.extension, Direction.UP).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
                if (down) {
                    quads.addAll(new TrsrBakedModel(this.extension, Direction.DOWN).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
                }
            }
        }
        if (state.getAttachmentState() != null) {
            for (Direction dir : Direction.values()) {
                ResourceLocation attachmentId = state.getAttachmentState()[dir.ordinal()];
                if (attachmentId == null) continue;
                quads.addAll(this.attachmentModels.get(attachmentId).get(dir).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
        }
        if (state.getState() != null) {
            boolean invNorth = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.INV_NORTH);
            boolean invEast = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.INV_EAST);
            boolean invSouth = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.INV_SOUTH);
            boolean invWest = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.INV_WEST);
            boolean invUp = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.INV_UP);
            boolean invDown = (Boolean)state.getState().func_177229_b((IProperty)PipeBlock.INV_DOWN);
            if (invNorth && !state.hasAttachmentState(Direction.NORTH)) {
                quads.addAll(this.inventoryAttachmentModels.get(Direction.NORTH).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
            if (invEast && !state.hasAttachmentState(Direction.EAST)) {
                quads.addAll(this.inventoryAttachmentModels.get(Direction.EAST).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
            if (invSouth && !state.hasAttachmentState(Direction.SOUTH)) {
                quads.addAll(this.inventoryAttachmentModels.get(Direction.SOUTH).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
            if (invWest && !state.hasAttachmentState(Direction.WEST)) {
                quads.addAll(this.inventoryAttachmentModels.get(Direction.WEST).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
            if (invUp && !state.hasAttachmentState(Direction.UP)) {
                quads.addAll(this.inventoryAttachmentModels.get(Direction.UP).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
            if (invDown && !state.hasAttachmentState(Direction.DOWN)) {
                quads.addAll(this.inventoryAttachmentModels.get(Direction.DOWN).getQuads(state.getState(), state.getSide(), state.getRand(), (IModelData)EmptyModelData.INSTANCE));
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.core.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.core.func_177556_c();
    }

    public boolean func_230044_c_() {
        return true;
    }

    public boolean func_188618_c() {
        return this.core.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.core.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.core.func_188617_f();
    }
}

