/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class GfxOpLine
extends GfxOp {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int color;

    public GfxOpLine() {
    }

    public GfxOpLine(int x1, int y1, int x2, int y2, int color) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        IVertexBuilder builder = buffer.getBuffer(CustomRenderTypes.OVERLAY_LINES);
        builder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)this.x1, (float)this.y1, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)this.x2, (float)this.y2, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    @Override
    public GfxOpType getType() {
        return GfxOpType.OP_LINE;
    }

    @Override
    protected void readFromNBTInternal(CompoundNBT tag) {
        this.x1 = tag.func_74771_c("x1");
        this.y1 = tag.func_74771_c("y1");
        this.x2 = tag.func_74771_c("x2");
        this.y2 = tag.func_74771_c("y2");
        this.color = tag.func_74762_e("color");
    }

    @Override
    protected void writeToNBTInternal(CompoundNBT tag) {
        tag.func_74774_a("x1", (byte)this.x1);
        tag.func_74774_a("y1", (byte)this.y1);
        tag.func_74774_a("x2", (byte)this.x2);
        tag.func_74774_a("y2", (byte)this.y2);
        tag.func_74768_a("color", this.color);
    }

    @Override
    protected void readFromBufInternal(PacketBuffer buf) {
        this.x1 = buf.readByte();
        this.y1 = buf.readByte();
        this.x2 = buf.readByte();
        this.y2 = buf.readByte();
        this.color = buf.readInt();
    }

    @Override
    protected void writeToBufInternal(PacketBuffer buf) {
        buf.writeByte(this.x1);
        buf.writeByte(this.y1);
        buf.writeByte(this.x2);
        buf.writeByte(this.y2);
        buf.writeInt(this.color);
    }
}

