/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.util;

import javax.annotation.Nonnull;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import net.minecraftforge.fluids.FluidStack;

public class MultiTankFluidProperties {
    @Nonnull
    private FluidStack contents = FluidStack.EMPTY;
    private final int capacity;
    private final boolean canFill;
    private final boolean canDrain;
    @Nonnull
    private final MultiTankTileEntity tankTileEntity;

    public MultiTankFluidProperties(@Nonnull MultiTankTileEntity tankTileEntity, @Nonnull FluidStack contents, int capacity) {
        this(tankTileEntity, contents, capacity, true, true);
    }

    public MultiTankFluidProperties(@Nonnull MultiTankTileEntity tankTileEntity, @Nonnull FluidStack contents, int capacity, boolean canFill, boolean canDrain) {
        this.tankTileEntity = tankTileEntity;
        this.contents = contents;
        this.capacity = capacity;
        this.canFill = canFill;
        this.canDrain = canDrain;
    }

    @Nonnull
    public FluidStack getContents() {
        return this.contents.copy();
    }

    @Nonnull
    public FluidStack getContentsInternal() {
        return this.contents;
    }

    public boolean hasContents() {
        return !this.contents.isEmpty();
    }

    public void drain(int amount) {
        if (this.contents.isEmpty()) {
            return;
        }
        this.contents.shrink(amount);
        if (this.contents.getAmount() <= 0) {
            this.contents = FluidStack.EMPTY;
        }
        this.tankTileEntity.func_70296_d();
    }

    public void fill(@Nonnull FluidStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        if (this.contents.isEmpty()) {
            this.contents = stack;
        } else {
            this.contents.setAmount(this.contents.getAmount() + stack.getAmount());
        }
        this.tankTileEntity.func_70296_d();
    }

    public void set(@Nonnull FluidStack stack) {
        this.contents = stack.isEmpty() ? FluidStack.EMPTY : stack.copy();
        this.tankTileEntity.func_70296_d();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill;
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain;
    }
}

