/*
 * Decompiled with CFR 0.152.
 */
package com.bagel.buzzierbees.core;

import com.bagel.buzzierbees.common.dispenser.BeeBottleDispenseBehavior;
import com.bagel.buzzierbees.common.dispenser.BugBottleDispenseBehavior;
import com.bagel.buzzierbees.core.other.BBBlockData;
import com.bagel.buzzierbees.core.registry.BBBlocks;
import com.bagel.buzzierbees.core.registry.BBEffects;
import com.bagel.buzzierbees.core.registry.BBEntities;
import com.bagel.buzzierbees.core.registry.BBFeatures;
import com.bagel.buzzierbees.core.registry.BBItems;
import com.bagel.buzzierbees.core.registry.BBVillagers;
import com.bagel.buzzierbees.core.util.BlockColorManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="buzzierbees")
@Mod.EventBusSubscriber(modid="buzzierbees")
public class BuzzierBees {
    public static final String MODID = "buzzierbees";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("buzzierbees");

    public BuzzierBees() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRY_HELPER.getDeferredBlockRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredItemRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredEntityRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredTileEntityRegister().register(modEventBus);
        BBEffects.EFFECTS.register(modEventBus);
        BBEffects.POTIONS.register(modEventBus);
        BBVillagers.PROFESSIONS.register(modEventBus);
        BBVillagers.POI_TYPES.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::replaceBeehivePOI);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
            modEventBus.addListener(EventPriority.LOWEST, this::registerItemColors);
        });
    }

    public void initSetupClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
    }

    private void setupClient(FMLClientSetupEvent event) {
        BBBlockData.setupRenderLayer();
        BBEntities.registerRendering();
        BlockColorManager.registerBlockColors();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        REGISTRY_HELPER.processSpawnEggColors(event);
    }

    private void setup(FMLCommonSetupEvent event) {
        BBBlockData.registerCompostables();
        BBBlockData.registerFlammables();
        BBEffects.addBrewingRecipes();
        BBFeatures.addFeatures();
        BBEntities.addEntitySpawns();
        BBVillagers.init();
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_BEE.get()), (IDispenseItemBehavior)new BeeBottleDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_SILVERFISH.get()), (IDispenseItemBehavior)new BugBottleDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BBItems.BOTTLE_OF_ENDERMITE.get()), (IDispenseItemBehavior)new BugBottleDispenseBehavior());
    }

    private void replaceBeehivePOI(FMLCommonSetupEvent event) {
        Set poiStates;
        ImmutableList BEEHIVES = ImmutableList.of((Object)Blocks.field_226906_mb_, (Object)BBBlocks.ACACIA_BEEHIVE.get(), (Object)BBBlocks.BIRCH_BEEHIVE.get(), (Object)BBBlocks.SPRUCE_BEEHIVE.get(), (Object)BBBlocks.DARK_OAK_BEEHIVE.get(), (Object)BBBlocks.JUNGLE_BEEHIVE.get(), (Object)BBBlocks.CRIMSON_BEEHIVE.get(), (Object)BBBlocks.WARPED_BEEHIVE.get(), (Object)BBBlocks.ROSEWOOD_BEEHIVE.get(), (Object)BBBlocks.YUCCA_BEEHIVE.get(), (Object)BBBlocks.KOUSA_BEEHIVE.get(), (Object)BBBlocks.ASPEN_BEEHIVE.get(), (Object[])new Block[]{(Block)BBBlocks.WILLOW_BEEHIVE.get(), (Block)BBBlocks.WISTERIA_BEEHIVE.get(), (Block)BBBlocks.MAPLE_BEEHIVE.get(), (Block)BBBlocks.BAMBOO_BEEHIVE.get(), (Block)BBBlocks.POISE_BEEHIVE.get(), (Block)BBBlocks.DRIFTWOOD_BEEHIVE.get(), (Block)BBBlocks.RIVER_BEEHIVE.get(), (Block)BBBlocks.SNAKE_BLOCK_BEEHIVE.get(), (Block)BBBlocks.BOP_FIR_BEEHIVE.get(), (Block)BBBlocks.BOP_DEAD_BEEHIVE.get(), (Block)BBBlocks.BOP_PALM_BEEHIVE.get(), (Block)BBBlocks.BOP_MAGIC_BEEHIVE.get(), (Block)BBBlocks.BOP_CHERRY_BEEHIVE.get(), (Block)BBBlocks.BOP_UMBRAN_BEEHIVE.get(), (Block)BBBlocks.BOP_WILLOW_BEEHIVE.get(), (Block)BBBlocks.BOP_REDWOOD_BEEHIVE.get(), (Block)BBBlocks.BOP_HELLBARK_BEEHIVE.get(), (Block)BBBlocks.BOP_MAHOGANY_BEEHIVE.get(), (Block)BBBlocks.BOP_JACARANDA_BEEHIVE.get()});
        HashSet validBlocks = new HashSet(TileEntityType.field_226985_G_.field_223046_I);
        validBlocks.addAll(BEEHIVES);
        TileEntityType.field_226985_G_.field_223046_I = validBlocks;
        PointOfInterestType.field_226356_s_.field_221075_w = poiStates = (Set)BEEHIVES.stream().flatMap(map -> map.func_176194_O().func_177619_a().stream()).collect(ImmutableSet.toImmutableSet());
        HashMap pointOfInterestTypeMap = new HashMap();
        BEEHIVES.stream().forEach(block -> block.func_176194_O().func_177619_a().forEach(state -> pointOfInterestTypeMap.put(state, PointOfInterestType.field_226356_s_)));
        PointOfInterestType.field_221073_u.putAll(pointOfInterestTypeMap);
    }
}

