/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncMap;
import top.theillusivec4.curios.server.command.CurioArgumentType;

public class CommandCurios {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        int opPermissionLevel = ServerLifecycleHooks.getCurrentServer().func_110455_j();
        LiteralArgumentBuilder curiosCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"curios").requires(player -> player.func_197034_c(opPermissionLevel));
        curiosCommand.then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.setSlotsOfPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandCurios.setSlotsOfPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.addSlotToPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandCurios.addSlotToPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.removeSlotFromPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandCurios.removeSlotFromPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.func_197057_a((String)"enable").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.enableSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"))))));
        curiosCommand.then(Commands.func_197057_a((String)"disable").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.disableSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"))))));
        curiosCommand.then(Commands.func_197057_a((String)"clear").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.clearSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), ""))).then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CommandCurios.clearSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"))))));
        curiosCommand.then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandCurios.resetSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))));
        dispatcher.register(curiosCommand);
    }

    private static int setSlotsOfPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot, int amount) {
        CuriosAPI.setSlotsForType(slot, (LivingEntity)playerMP, amount);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.set.success", new Object[]{slot, CuriosAPI.getSlotsForType((LivingEntity)playerMP, slot), playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int addSlotToPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot, int amount) {
        CuriosAPI.addTypeSlotsToEntity(slot, amount, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.add.success", new Object[]{amount, slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int removeSlotFromPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot, int amount) {
        CuriosAPI.removeTypeSlotsFromEntity(slot, amount, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.remove.success", new Object[]{amount, slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int enableSlotForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot) {
        CuriosAPI.enableTypeForEntity(slot, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.enable.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int disableSlotForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot) {
        CuriosAPI.disableTypeForEntity(slot, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.disable.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int clearSlotsForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot) {
        CuriosAPI.getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            SortedMap<String, CurioStackHandler> map = handler.getCurioMap();
            if (!slot.isEmpty() && map.get(slot) != null) {
                CommandCurios.clear((CurioStackHandler)((Object)((Object)map.get(slot))));
            } else {
                for (String id : map.keySet()) {
                    CommandCurios.clear((CurioStackHandler)((Object)((Object)map.get(id))));
                }
            }
        });
        if (slot.isEmpty()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.clearAll.success", new Object[]{playerMP.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.clear.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        }
        return 1;
    }

    private static int resetSlotsForPlayer(CommandSource source, ServerPlayerEntity playerMP) {
        CuriosAPI.getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            TreeMap slots = Maps.newTreeMap();
            CuriosAPI.getTypeIdentifiers().forEach(id -> CuriosAPI.getType(id).ifPresent(type -> slots.put(id, new CurioStackHandler(type.getSize()))));
            handler.setCurioMap(slots);
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new SPacketSyncMap(playerMP.func_145782_y(), handler.getCurioMap()));
        });
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.reset.success", new Object[]{playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static void clear(CurioStackHandler stacks) {
        for (int i = 0; i < stacks.getSlots(); ++i) {
            stacks.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }
}

