/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;

public interface ICurio {
    default public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
    }

    default public void onCurioAnimate(String identifier, int index, LivingEntity livingEntity) {
    }

    default public void onEquipped(String identifier, LivingEntity livingEntity) {
    }

    default public void onUnequipped(String identifier, LivingEntity livingEntity) {
    }

    default public boolean canEquip(String identifier, LivingEntity livingEntity) {
        return true;
    }

    default public boolean canUnequip(String identifier, LivingEntity livingEntity) {
        return true;
    }

    default public List<ITextComponent> getTagsTooltip(List<ITextComponent> tagTooltips) {
        return tagTooltips;
    }

    default public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
        return HashMultimap.create();
    }

    default public void playEquipSound(LivingEntity livingEntity) {
        livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_180425_c(), SoundEvents.field_187719_p, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    default public boolean canRightClickEquip() {
        return false;
    }

    default public void onCurioBreak(ItemStack stack, LivingEntity livingEntity) {
        if (!stack.func_190926_b()) {
            if (!livingEntity.func_174814_R()) {
                livingEntity.field_70170_p.func_184134_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_187635_cQ, livingEntity.func_184176_by(), 0.8f, 0.8f + livingEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f, false);
            }
            for (int i = 0; i < 5; ++i) {
                Vec3d vec3d = new Vec3d(((double)livingEntity.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d = vec3d.func_178789_a(-livingEntity.field_70125_A * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-livingEntity.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-livingEntity.func_70681_au().nextFloat()) * 0.6 - 0.3;
                Vec3d vec3d1 = new Vec3d(((double)livingEntity.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec3d1 = vec3d1.func_178789_a(-livingEntity.field_70125_A * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_178785_b(-livingEntity.field_70177_z * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_72441_c(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + (double)livingEntity.func_70047_e(), livingEntity.func_226281_cx_());
                livingEntity.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
            }
        }
    }

    default public boolean shouldSyncToTracking(String identifier, LivingEntity livingEntity) {
        return false;
    }

    @Nonnull
    default public CompoundNBT getSyncTag() {
        return new CompoundNBT();
    }

    default public void readSyncTag(CompoundNBT compound) {
    }

    @Nonnull
    default public DropRule getDropRule(LivingEntity livingEntity) {
        return DropRule.DEFAULT;
    }

    default public boolean hasRender(String identifier, LivingEntity livingEntity) {
        return false;
    }

    default public void render(String identifier, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public static final class RenderHelper {
        public static void translateIfSneaking(MatrixStack matrixStack, LivingEntity livingEntity) {
            if (livingEntity.func_213453_ef()) {
                matrixStack.func_227861_a_(0.0, (double)0.2f, 0.0);
            }
        }

        public static void rotateIfSneaking(MatrixStack matrixStack, LivingEntity livingEntity) {
            if (livingEntity.func_213453_ef()) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(28.647888f));
            }
        }

        public static void followHeadRotations(LivingEntity livingEntity, ModelRenderer ... renderers) {
            LivingRenderer livingRenderer;
            EntityModel model;
            EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)livingEntity);
            if (render instanceof LivingRenderer && (model = (livingRenderer = (LivingRenderer)render).func_217764_d()) instanceof BipedModel) {
                for (ModelRenderer renderer : renderers) {
                    renderer.func_217177_a(((BipedModel)model).field_78116_c);
                }
            }
        }

        @SafeVarargs
        public static void followBodyRotations(LivingEntity livingEntity, BipedModel<LivingEntity> ... models) {
            LivingRenderer livingRenderer;
            EntityModel entityModel;
            EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)livingEntity);
            if (render instanceof LivingRenderer && (entityModel = (livingRenderer = (LivingRenderer)render).func_217764_d()) instanceof BipedModel) {
                for (BipedModel<LivingEntity> model : models) {
                    BipedModel bipedModel = (BipedModel)entityModel;
                    bipedModel.func_217148_a(model);
                }
            }
        }
    }

    public static enum DropRule {
        DEFAULT,
        ALWAYS_DROP,
        ALWAYS_KEEP,
        DESTROY;

    }
}

