/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.fabric;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import me.shedaniel.cloth.hooks.ClothClientHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.FabricKeyBinding;
import net.fabricmc.fabric.api.client.keybinding.KeyBindingRegistry;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL11;

public class LightOverlay
implements ClientModInitializer {
    static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    private static final String KEYBIND_CATEGORY = "key.lightoverlay.category";
    private static final class_2960 ENABLE_OVERLAY_KEYBIND = new class_2960("lightoverlay", "enable_overlay");
    private static final class_2960 INCREASE_REACH_KEYBIND = new class_2960("lightoverlay", "increase_reach");
    private static final class_2960 DECREASE_REACH_KEYBIND = new class_2960("lightoverlay", "decrease_reach");
    private static final class_2960 INCREASE_LINE_WIDTH_KEYBIND = new class_2960("lightoverlay", "increase_line_width");
    private static final class_2960 DECREASE_LINE_WIDTH_KEYBIND = new class_2960("lightoverlay", "decrease_line_width");
    static int reach = 12;
    static int crossLevel = 7;
    static boolean showNumber = false;
    static boolean smoothLines = true;
    static boolean underwater = false;
    static float lineWidth = 1.0f;
    static int yellowColor = 0xFFFF00;
    static int redColor = 0xFF0000;
    static File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "lightoverlay.properties");
    private static FabricKeyBinding enableOverlay;
    private static FabricKeyBinding increaseReach;
    private static FabricKeyBinding decreaseReach;
    private static FabricKeyBinding increaseLineWidth;
    private static FabricKeyBinding decreaseLineWidth;
    private static boolean enabled;
    private static class_1299<class_1297> testingEntityType;
    private static int threadNumber;
    private static final ExecutorService EXECUTOR;
    private static final List<class_1923> POS;
    private static final Map<class_1923, Map<Long, Object>> CHUNK_MAP;
    private static long ticks;

    public static void queueChunkAndNear(class_1923 pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                LightOverlay.queueChunk(new class_1923(pos.field_9181 + xOffset, pos.field_9180 + zOffset));
            }
        }
    }

    public static void queueChunk(class_1923 pos) {
        if (!POS.contains(pos)) {
            POS.add(0, pos);
        }
    }

    public static int getChunkRange() {
        return Math.max(class_3532.method_15386((float)((float)reach / 16.0f)), 1);
    }

    private static void calculateChunk(class_2818 chunk, class_1937 world, class_1923 chunkPos, class_3726 entityContext) {
        HashMap map = Maps.newHashMap();
        if (chunk != null) {
            class_3562 block = chunk.method_12023().method_15562(class_1944.field_9282);
            class_3562 sky = showNumber ? null : chunk.method_12023().method_15562(class_1944.field_9284);
            for (class_2338 pos : class_2338.method_10094((int)chunkPos.method_8326(), (int)0, (int)chunkPos.method_8328(), (int)chunkPos.method_8327(), (int)256, (int)chunkPos.method_8329())) {
                CrossType type;
                class_2338 down = pos.method_10074();
                if (showNumber) {
                    int level = LightOverlay.getCrossLevel(pos, down, (class_1922)chunk, block, entityContext);
                    if (level < 0) continue;
                    map.put(pos.method_10063(), level);
                    continue;
                }
                class_1959 biome = world.method_22385().method_22393(pos);
                if (!(biome.method_8690() > 0.0f) || biome.method_8700(class_1311.field_6302).isEmpty() || (type = LightOverlay.getCrossType(pos, down, (class_1922)chunk, block, sky, entityContext)) == CrossType.NONE) continue;
                map.put(pos.method_10063(), type);
            }
        }
        CHUNK_MAP.put(chunkPos, map);
    }

    public static CrossType getCrossType(class_2338 pos, class_2338 down, class_1922 world, class_3562 block, class_3562 sky, class_3726 entityContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 upperCollisionShape = blockUpperState.method_16337(world, pos, entityContext);
        if (!underwater && !blockUpperState.method_11618().method_15769()) {
            return CrossType.NONE;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11036)) {
            return CrossType.NONE;
        }
        if (blockUpperState.method_11634()) {
            return CrossType.NONE;
        }
        if (upperCollisionShape.method_1105(class_2350.class_2351.field_11052) > 0.0) {
            return CrossType.NONE;
        }
        if (blockUpperState.method_11614().method_9525(class_3481.field_15463)) {
            return CrossType.NONE;
        }
        if (!blockBelowState.method_11611(world, down, testingEntityType)) {
            return CrossType.NONE;
        }
        if (block.method_15543(pos) > crossLevel) {
            return CrossType.NONE;
        }
        if (sky.method_15543(pos) > crossLevel) {
            return CrossType.YELLOW;
        }
        return CrossType.RED;
    }

    public static int getCrossLevel(class_2338 pos, class_2338 down, class_1922 world, class_3562 view, class_3726 entityContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 collisionShape = blockBelowState.method_16337(world, down, entityContext);
        class_265 upperCollisionShape = blockUpperState.method_16337(world, pos, entityContext);
        if (!underwater && !blockUpperState.method_11618().method_15769()) {
            return -1;
        }
        if (!blockBelowState.method_11618().method_15769()) {
            return -1;
        }
        if (blockBelowState.method_11588()) {
            return -1;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11033)) {
            return -1;
        }
        return view.method_15543(pos);
    }

    public static void renderCross(class_289 tessellator, class_287 buffer, class_4184 camera, class_1937 world, class_2338 pos, int color, class_3726 entityContext) {
        double d0 = camera.method_19326().field_1352;
        double d1 = camera.method_19326().field_1351 - 0.005;
        class_265 upperOutlineShape = world.method_8320(pos).method_11606((class_1922)world, pos, entityContext);
        if (!upperOutlineShape.method_1110()) {
            d1 -= upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double d2 = camera.method_19326().field_1350;
        buffer.method_1328(1, class_290.field_1576);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        buffer.method_22912((double)pos.method_10263() + 0.01 - d0, (double)pos.method_10264() - d1, (double)pos.method_10260() + 0.01 - d2).method_1336(red, green, blue, 255).method_1344();
        buffer.method_22912((double)pos.method_10263() - 0.01 + 1.0 - d0, (double)pos.method_10264() - d1, (double)pos.method_10260() - 0.01 + 1.0 - d2).method_1336(red, green, blue, 255).method_1344();
        buffer.method_22912((double)pos.method_10263() - 0.01 + 1.0 - d0, (double)pos.method_10264() - d1, (double)pos.method_10260() + 0.01 - d2).method_1336(red, green, blue, 255).method_1344();
        buffer.method_22912((double)pos.method_10263() + 0.01 - d0, (double)pos.method_10264() - d1, (double)pos.method_10260() - 0.01 + 1.0 - d2).method_1336(red, green, blue, 255).method_1344();
        tessellator.method_1350();
    }

    public static void renderLevel(class_310 client, class_4184 camera, class_1937 world, class_2338 pos, class_2338 down, int level, class_3726 entityContext) {
        String string_1 = String.valueOf(level);
        class_327 textRenderer_1 = client.field_1772;
        double double_4 = camera.method_19326().field_1352;
        double double_5 = camera.method_19326().field_1351;
        class_265 upperOutlineShape = world.method_8320(down).method_11606((class_1922)world, down, entityContext);
        if (!upperOutlineShape.method_1110()) {
            double_5 += 1.0 - upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double double_6 = camera.method_19326().field_1350;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)((double)((float)pos.method_10263() + 0.5f) - double_4)), (float)((float)((double)pos.method_10264() - double_5) + 0.005f), (float)((float)((double)((float)pos.method_10260() + 0.5f) - double_6)));
        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        float size = 0.07f;
        RenderSystem.scalef((float)(-size), (float)(-size), (float)size);
        float float_3 = (float)(-textRenderer_1.method_1727(string_1)) / 2.0f + 0.4f;
        RenderSystem.enableAlphaTest();
        class_4597.class_4598 vertexConsumerProvider$Immediate_1 = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        textRenderer_1.method_22942(string_1, float_3, -3.5f, level > crossLevel ? -16505852 : -9236207, false, class_4590.method_22931().method_22936(), (class_4597)vertexConsumerProvider$Immediate_1, false, 0, 0xF000F0);
        vertexConsumerProvider$Immediate_1.method_22993();
        RenderSystem.popMatrix();
    }

    static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            if (!file.exists() || !file.canRead()) {
                LightOverlay.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            smoothLines = ((String)properties.computeIfAbsent("smoothLines", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            LightOverlay.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            crossLevel = 7;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            showNumber = false;
            smoothLines = true;
            underwater = false;
            try {
                LightOverlay.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        CHUNK_MAP.clear();
        POS.clear();
    }

    static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("smoothLines=" + smoothLines).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.close();
    }

    public void onInitializeClient() {
        LightOverlay.loadConfig(configFile);
        testingEntityType = class_1299.class_1300.method_5902((class_1311)class_1311.field_6302).method_17687(0.0f, 0.0f).method_5904().method_5905(null);
        class_310 client = class_310.method_1551();
        KeyBindingRegistry.INSTANCE.addCategory(KEYBIND_CATEGORY);
        enableOverlay = FabricKeyBinding.Builder.create((class_2960)ENABLE_OVERLAY_KEYBIND, (class_3675.class_307)class_3675.class_307.field_1668, (int)296, (String)KEYBIND_CATEGORY).build();
        KeyBindingRegistry.INSTANCE.register(enableOverlay);
        increaseReach = FabricKeyBinding.Builder.create((class_2960)INCREASE_REACH_KEYBIND, (class_3675.class_307)class_3675.class_307.field_1668, (int)-1, (String)KEYBIND_CATEGORY).build();
        KeyBindingRegistry.INSTANCE.register(increaseReach);
        decreaseReach = FabricKeyBinding.Builder.create((class_2960)DECREASE_REACH_KEYBIND, (class_3675.class_307)class_3675.class_307.field_1668, (int)-1, (String)KEYBIND_CATEGORY).build();
        KeyBindingRegistry.INSTANCE.register(decreaseReach);
        increaseLineWidth = FabricKeyBinding.Builder.create((class_2960)INCREASE_LINE_WIDTH_KEYBIND, (class_3675.class_307)class_3675.class_307.field_1668, (int)-1, (String)KEYBIND_CATEGORY).build();
        KeyBindingRegistry.INSTANCE.register(increaseLineWidth);
        decreaseLineWidth = FabricKeyBinding.Builder.create((class_2960)DECREASE_LINE_WIDTH_KEYBIND, (class_3675.class_307)class_3675.class_307.field_1668, (int)-1, (String)KEYBIND_CATEGORY).build();
        KeyBindingRegistry.INSTANCE.register(decreaseLineWidth);
        ClothClientHooks.HANDLE_INPUT.register(minecraftClient -> {
            while (enableOverlay.method_1436()) {
                enabled = !enabled;
            }
            while (increaseReach.method_1436()) {
                if (reach < 64) {
                    ++reach;
                }
                try {
                    LightOverlay.saveConfig(configFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                client.field_1724.method_7353((class_2561)new class_2588("text.lightoverlay.current_reach", new Object[]{reach}), false);
            }
            while (decreaseReach.method_1436()) {
                if (reach > 1) {
                    --reach;
                }
                try {
                    LightOverlay.saveConfig(configFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                client.field_1724.method_7353((class_2561)new class_2588("text.lightoverlay.current_reach", new Object[]{reach}), false);
            }
            while (increaseLineWidth.method_1436()) {
                if (lineWidth < 7.0f) {
                    lineWidth += 0.1f;
                }
                try {
                    LightOverlay.saveConfig(configFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                client.field_1724.method_7353((class_2561)new class_2588("text.lightoverlay.current_line_width", new Object[]{FORMAT.format(lineWidth)}), false);
            }
            while (decreaseLineWidth.method_1436()) {
                if (lineWidth > 1.0f) {
                    lineWidth -= 0.1f;
                }
                try {
                    LightOverlay.saveConfig(configFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                client.field_1724.method_7353((class_2561)new class_2588("text.lightoverlay.current_line_width", new Object[]{FORMAT.format(lineWidth)}), false);
            }
        });
        ClothClientHooks.DEBUG_RENDER_PRE.register(() -> {
            if (enabled) {
                class_746 playerEntity = client.field_1724;
                int playerPosX = (int)playerEntity.method_23317() >> 4;
                int playerPosZ = (int)playerEntity.method_23321() >> 4;
                class_3726 entityContext = class_3726.method_16195((class_1297)playerEntity);
                class_638 world = client.field_1687;
                class_2338 playerPos = new class_2338(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                if (showNumber) {
                    RenderSystem.enableTexture();
                    RenderSystem.depthMask((boolean)true);
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    for (Map.Entry<class_1923, Map<Long, Object>> entry : CHUNK_MAP.entrySet()) {
                        if (class_3532.method_15382((int)(entry.getKey().field_9181 - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(entry.getKey().field_9180 - playerPosZ)) > LightOverlay.getChunkRange()) continue;
                        for (Map.Entry<Long, Object> objectEntry : entry.getValue().entrySet()) {
                            if (!(objectEntry.getValue() instanceof Integer)) continue;
                            mutable.method_10103(class_2338.method_10061((long)objectEntry.getKey()), class_2338.method_10071((long)objectEntry.getKey()), class_2338.method_10083((long)objectEntry.getKey()));
                            if (!mutable.method_19771((class_2382)playerPos, (double)reach)) continue;
                            class_2338 down = mutable.method_10074();
                            LightOverlay.renderLevel(client, camera, (class_1937)world, (class_2338)mutable, down, (Integer)objectEntry.getValue(), entityContext);
                        }
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableDepthTest();
                } else {
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableTexture();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.SRC_ALPHA, (class_4493.class_4534)class_4493.class_4534.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.disableLighting();
                    if (smoothLines) {
                        GL11.glEnable((int)2848);
                    }
                    RenderSystem.lineWidth((float)lineWidth);
                    class_289 tessellator = class_289.method_1348();
                    class_287 buffer = tessellator.method_1349();
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    for (Map.Entry<class_1923, Map<Long, Object>> entry : CHUNK_MAP.entrySet()) {
                        if (class_3532.method_15382((int)(entry.getKey().field_9181 - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(entry.getKey().field_9180 - playerPosZ)) > LightOverlay.getChunkRange()) continue;
                        for (Map.Entry<Long, Object> objectEntry : entry.getValue().entrySet()) {
                            if (!(objectEntry.getValue() instanceof CrossType)) continue;
                            mutable.method_10103(class_2338.method_10061((long)objectEntry.getKey()), class_2338.method_10071((long)objectEntry.getKey()), class_2338.method_10083((long)objectEntry.getKey()));
                            if (!mutable.method_19771((class_2382)playerPos, (double)reach)) continue;
                            class_2338 down = mutable.method_10074();
                            int color = objectEntry.getValue() == CrossType.RED ? redColor : yellowColor;
                            LightOverlay.renderCross(tessellator, buffer, camera, (class_1937)world, (class_2338)mutable, color, entityContext);
                        }
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.enableTexture();
                    if (smoothLines) {
                        GL11.glDisable((int)2848);
                    }
                }
            }
        });
    }

    static {
        enabled = false;
        threadNumber = 0;
        EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
            Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
            thread.setDaemon(true);
            return thread;
        });
        POS = Lists.newCopyOnWriteArrayList();
        CHUNK_MAP = Maps.newConcurrentMap();
        ticks = 0L;
        ClientTickCallback.EVENT.register(client -> {
            try {
                ++ticks;
                if (class_310.method_1551().field_1724 == null || !enabled) {
                    POS.clear();
                    CHUNK_MAP.clear();
                } else {
                    class_746 player = class_310.method_1551().field_1724;
                    class_638 world = class_310.method_1551().field_1687;
                    class_3726 entityContext = class_3726.method_16195((class_1297)player);
                    class_243[] playerPos = new class_243[]{null};
                    int playerPosX = (int)player.method_23317() >> 4;
                    int playerPosZ = (int)player.method_23321() >> 4;
                    if (ticks % 20L == 0L) {
                        for (int chunkX = playerPosX - LightOverlay.getChunkRange(); chunkX <= playerPosX + LightOverlay.getChunkRange(); ++chunkX) {
                            for (int chunkZ = playerPosZ - LightOverlay.getChunkRange(); chunkZ <= playerPosZ + LightOverlay.getChunkRange(); ++chunkZ) {
                                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                                if (CHUNK_MAP.containsKey(chunkPos)) continue;
                                LightOverlay.queueChunk(chunkPos);
                            }
                        }
                    }
                    if (!POS.isEmpty()) {
                        if (playerPos[0] == null) {
                            playerPos[0] = player.method_19538();
                        }
                        class_1923 pos = POS.stream().min(Comparator.comparingDouble(value -> value.method_8330(8, 0, 8).method_10268(playerPos[0].field_1352, 0.0, playerPos[0].field_1350, false))).get();
                        EXECUTOR.submit(() -> {
                            if (class_3532.method_15382((int)(pos.field_9181 - playerPosX)) <= LightOverlay.getChunkRange() && class_3532.method_15382((int)(pos.field_9180 - playerPosZ)) <= LightOverlay.getChunkRange()) {
                                LightOverlay.calculateChunk(world.method_2935().method_2857(pos.field_9181, pos.field_9180, class_2806.field_12803, false), (class_1937)world, pos, entityContext);
                            } else {
                                CHUNK_MAP.remove(pos);
                            }
                        });
                        POS.remove(pos);
                    }
                    Iterator<Map.Entry<class_1923, Map<Long, Object>>> chunkMapIterator = CHUNK_MAP.entrySet().iterator();
                    while (chunkMapIterator.hasNext()) {
                        Map.Entry<class_1923, Map<Long, Object>> pos = chunkMapIterator.next();
                        if (class_3532.method_15382((int)(pos.getKey().field_9181 - playerPosX)) <= LightOverlay.getChunkRange() * 2 && class_3532.method_15382((int)(pos.getKey().field_9180 - playerPosZ)) <= LightOverlay.getChunkRange() * 2) continue;
                        chunkMapIterator.remove();
                    }
                }
            }
            catch (Exception e) {
                LogManager.getLogger().throwing((Throwable)e);
            }
        });
    }

    private static enum CrossType {
        YELLOW,
        RED,
        NONE;

    }
}

