/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileComponent;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TileComponentSecurity
implements ITileComponent {
    public TileEntityMekanism tile;
    private UUID ownerUUID;
    private String clientOwner;
    private ISecurityTile.SecurityMode securityMode = ISecurityTile.SecurityMode.PUBLIC;
    private SecurityFrequency frequency;

    public TileComponentSecurity(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    public SecurityFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(UUID owner) {
        FrequencyManager manager = Mekanism.securityFrequencies;
        manager.deactivate(Coord4D.get(this.tile));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.ownerUUID.equals(owner)) continue;
            this.frequency = (SecurityFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this.tile));
            return;
        }
        Frequency freq = new SecurityFrequency(owner).setPublic(true);
        freq.activeCoords.add(Coord4D.get(this.tile));
        manager.addFrequency(freq);
        this.frequency = (SecurityFrequency)freq;
        this.tile.markDirty(false);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.frequency = null;
        this.ownerUUID = uuid;
    }

    public String getClientOwner() {
        return this.clientOwner;
    }

    public ISecurityTile.SecurityMode getMode() {
        if (MekanismConfig.general.allowProtection.get()) {
            return this.securityMode;
        }
        return ISecurityTile.SecurityMode.PUBLIC;
    }

    public void setMode(ISecurityTile.SecurityMode mode) {
        this.securityMode = mode;
        this.tile.markDirty(false);
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.ownerUUID == null || freq == null) {
            return null;
        }
        return Mekanism.securityFrequencies;
    }

    @Override
    public void tick() {
        if (!this.tile.isRemote()) {
            FrequencyManager manager;
            if (this.frequency == null && this.ownerUUID != null) {
                this.setFrequency(this.ownerUUID);
            }
            if ((manager = this.getManager(this.frequency)) == null) {
                this.frequency = null;
            } else {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (SecurityFrequency)manager.validateFrequency(this.ownerUUID, Coord4D.get(this.tile), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = (SecurityFrequency)manager.update(Coord4D.get(this.tile), this.frequency);
                }
            }
        }
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentSecurity", 10)) {
            CompoundNBT securityNBT = nbtTags.func_74775_l("componentSecurity");
            NBTUtils.setEnumIfPresent(securityNBT, "securityMode", ISecurityTile.SecurityMode::byIndexStatic, mode -> {
                this.securityMode = mode;
            });
            NBTUtils.setUUIDIfPresent(securityNBT, "owner", uuid -> {
                this.ownerUUID = uuid;
            });
            if (securityNBT.func_150297_b("frequency", 10)) {
                this.frequency = new SecurityFrequency(securityNBT.func_74775_l("frequency"), false);
                this.frequency.valid = false;
            }
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT securityNBT = new CompoundNBT();
        securityNBT.func_74768_a("securityMode", this.securityMode.ordinal());
        if (this.ownerUUID != null) {
            securityNBT.func_186854_a("owner", this.ownerUUID);
        }
        if (this.frequency != null) {
            CompoundNBT frequencyTag = new CompoundNBT();
            this.frequency.write(frequencyTag);
            securityNBT.func_218657_a("frequency", (INBT)frequencyTag);
        }
        nbtTags.func_218657_a("componentSecurity", (INBT)securityNBT);
    }

    @Override
    public void invalidate() {
        FrequencyManager manager;
        if (!this.tile.isRemote() && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this.tile));
        }
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        container.track(SyncableEnum.create(ISecurityTile.SecurityMode::byIndexStatic, ISecurityTile.SecurityMode.PUBLIC, this::getMode, this::setMode));
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
        if (this.ownerUUID != null) {
            updateTag.func_186854_a("owner", this.ownerUUID);
            updateTag.func_74778_a("ownerName", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
        NBTUtils.setUUIDIfPresent(updateTag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(updateTag, "ownerName", uuid -> {
            this.clientOwner = uuid;
        });
    }
}

