/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class CapabilityTileEntity
extends TileEntityUpdateable {
    private final CapabilityCache capabilityCache = new CapabilityCache();

    public CapabilityTileEntity(TileEntityType<?> type) {
        super(type);
    }

    protected final void addCapabilityResolver(ICapabilityResolver resolver) {
        this.capabilityCache.addCapabilityResolver(resolver);
    }

    protected final void addDisabledCapabilities(Capability<?> ... capabilities) {
        this.capabilityCache.addDisabledCapabilities(capabilities);
    }

    protected final void addDisabledCapabilities(Collection<Capability<?>> capabilities) {
        this.capabilityCache.addDisabledCapabilities(capabilities);
    }

    protected final void addSemiDisabledCapability(Capability<?> capability, BooleanSupplier checker) {
        this.capabilityCache.addSemiDisabledCapability(capability, checker);
    }

    protected final void addConfigComponent(TileComponentConfig config) {
        this.capabilityCache.addConfigComponent(config);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.capabilityCache.isCapabilityDisabled(capability, side)) {
            return LazyOptional.empty();
        }
        if (this.capabilityCache.canResolve(capability)) {
            return this.capabilityCache.getCapabilityUnchecked(capability, side);
        }
        return super.getCapability(capability, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.invalidateCachedCapabilities();
    }

    protected void invalidateCachedCapabilities() {
        this.capabilityCache.invalidateAll();
    }

    public void invalidateCapability(@Nonnull Capability<?> capability, @Nullable Direction side) {
        this.capabilityCache.invalidate(capability, side);
    }

    public void invalidateCapabilities(@Nonnull Collection<Capability<?>> capabilities, @Nullable Direction side) {
        for (Capability<?> capability : capabilities) {
            this.invalidateCapability(capability, side);
        }
    }
}

