/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.base.ContainerEditMode;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankUpdateProtocol;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityDynamicTank
extends TileEntityMultiblock<SynchronizedTankData>
implements IFluidContainerManager,
IValveHandler {
    public float prevScale;

    public TileEntityDynamicTank() {
        this(MekanismBlocks.DYNAMIC_TANK);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public TileEntityDynamicTank(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null && this.isRendering) {
            boolean needsPacket = this.needsValveUpdate();
            List<IInventorySlot> inventorySlots = ((SynchronizedTankData)this.structure).getInventorySlots(null);
            FluidInventorySlot inputSlot = (FluidInventorySlot)inventorySlots.get(0);
            inputSlot.handleTank(inventorySlots.get(1), ((SynchronizedTankData)this.structure).editMode);
            float scale = MekanismUtils.getScale(this.prevScale, ((SynchronizedTankData)this.structure).fluidTank);
            if (scale != this.prevScale) {
                needsPacket = true;
                this.prevScale = scale;
            }
            if (needsPacket) {
                this.sendUpdatePacket();
            }
        }
    }

    @Override
    public ActionResultType onActivate(PlayerEntity player, Hand hand, ItemStack stack) {
        if (!player.func_225608_bj_() && this.structure != null) {
            if (this.manageInventory(player, hand, stack)) {
                player.field_71071_by.func_70296_d();
                return ActionResultType.SUCCESS;
            }
            return this.openGui(player);
        }
        return ActionResultType.PASS;
    }

    @Override
    @Nonnull
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData(this);
    }

    public TankCache getNewCache() {
        return new TankCache();
    }

    protected TankUpdateProtocol getProtocol() {
        return new TankUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    public ContainerEditMode getContainerEditMode() {
        if (this.structure == null) {
            return ContainerEditMode.BOTH;
        }
        return ((SynchronizedTankData)this.structure).editMode;
    }

    @Override
    public void nextMode() {
        if (this.structure != null) {
            ((SynchronizedTankData)this.structure).editMode = (ContainerEditMode)((SynchronizedTankData)this.structure).editMode.getNext();
        }
    }

    private boolean manageInventory(PlayerEntity player, Hand hand, ItemStack itemStack) {
        if (this.structure == null) {
            return false;
        }
        ItemStack copyStack = StackUtils.size(itemStack, 1);
        Optional fluidHandlerItem = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)copyStack));
        if (fluidHandlerItem.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerItem.get();
            FluidStack fluidInItem = ((SynchronizedTankData)this.structure).fluidTank.isEmpty() ? handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : handler.drain(new FluidStack(((SynchronizedTankData)this.structure).fluidTank.getFluid(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            if (fluidInItem.isEmpty()) {
                if (!((SynchronizedTankData)this.structure).fluidTank.isEmpty()) {
                    int filled = handler.fill(((SynchronizedTankData)this.structure).fluidTank.getFluid(), player.func_184812_l_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = handler.getContainer();
                    if (filled > 0) {
                        boolean removeFluid = false;
                        if (player.func_184812_l_()) {
                            removeFluid = true;
                        } else if (itemStack.func_190916_E() == 1) {
                            removeFluid = true;
                            player.func_184611_a(hand, container);
                        } else if (itemStack.func_190916_E() > 1 && player.field_71071_by.func_70441_a(container)) {
                            removeFluid = true;
                            itemStack.func_190918_g(1);
                        }
                        if (removeFluid) {
                            ((SynchronizedTankData)this.structure).fluidTank.shrinkStack(filled, Action.EXECUTE);
                        }
                        return true;
                    }
                }
            } else if (((SynchronizedTankData)this.structure).fluidTank.isEmpty() || ((SynchronizedTankData)this.structure).fluidTank.getFluid().isFluidEqual(fluidInItem)) {
                boolean filled = false;
                FluidStack drained = handler.drain(((SynchronizedTankData)this.structure).fluidTank.getNeeded(), player.func_184812_l_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                ItemStack container = handler.getContainer();
                if (!drained.isEmpty()) {
                    if (player.func_184812_l_()) {
                        filled = true;
                    } else if (!container.func_190926_b()) {
                        if (itemStack.func_190916_E() == 1) {
                            player.func_184611_a(hand, container);
                            filled = true;
                        } else if (player.field_71071_by.func_70441_a(container)) {
                            itemStack.func_190918_g(1);
                            filled = true;
                        }
                    } else {
                        itemStack.func_190918_g(1);
                        if (itemStack.func_190926_b()) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (((SynchronizedTankData)this.structure).fluidTank.isEmpty()) {
                            ((SynchronizedTankData)this.structure).fluidTank.setStack(drained);
                        } else {
                            ((SynchronizedTankData)this.structure).fluidTank.growStack(drained.getAmount(), Action.EXECUTE);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public Collection<IValveHandler.ValveData> getValveData() {
        return this.structure != null ? ((SynchronizedTankData)this.structure).valves : null;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.structure != null && this.isRendering) {
            updateTag.func_74776_a("scale", this.prevScale);
            updateTag.func_74768_a("volume", ((SynchronizedTankData)this.structure).getVolume());
            updateTag.func_218657_a("fluid", (INBT)((SynchronizedTankData)this.structure).fluidTank.getFluid().writeToNBT(new CompoundNBT()));
            this.writeValves(updateTag);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        if (this.clientHasStructure && this.isRendering && this.structure != null) {
            NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
                this.prevScale = scale;
            });
            NBTUtils.setIntIfPresent(tag, "volume", value -> ((SynchronizedTankData)this.structure).setVolume(value));
            NBTUtils.setFluidStackIfPresent(tag, "fluid", value -> ((SynchronizedTankData)this.structure).fluidTank.setStack((FluidStack)value));
            this.readValves(tag);
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(ContainerEditMode::byIndexStatic, ContainerEditMode.BOTH, this::getContainerEditMode, mode -> {
            if (this.structure != null) {
                ((SynchronizedTankData)this.structure).editMode = mode;
            }
        }));
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedTankData)this.structure).getVolume(), value -> {
            if (this.structure != null) {
                ((SynchronizedTankData)this.structure).setVolume(value);
            }
        }));
        container.track(SyncableFluidStack.create(() -> this.structure == null ? FluidStack.EMPTY : ((SynchronizedTankData)this.structure).fluidTank.getFluid(), value -> {
            if (this.structure != null) {
                ((SynchronizedTankData)this.structure).fluidTank.setStack((FluidStack)value);
            }
        }));
    }
}

