/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.Arrays;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public abstract class TransporterFilter<FILTER extends TransporterFilter<FILTER>>
extends BaseFilter<FILTER> {
    public static final int MAX_LENGTH = 48;
    public static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('*'), Character.valueOf('-'), Character.valueOf(' '), Character.valueOf('|'), Character.valueOf('_'), Character.valueOf('\''));
    public EnumColor color;
    public boolean allowDefault;

    public boolean canFilter(ItemStack itemStack, boolean strict) {
        return !itemStack.func_190926_b();
    }

    public abstract Finder getFinder();

    public InvStack getStackFromInventory(TileEntity tile, Direction side, boolean singleItem) {
        return InventoryUtils.takeTopStack(tile, side, this.getFinder(), singleItem ? 1 : 64);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("allowDefault", this.allowDefault);
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        this.allowDefault = nbtTags.func_74767_n("allowDefault");
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.allowDefault);
        buffer.func_150787_b(TransporterUtils.getColorIndex(this.color));
    }

    @Override
    public void read(PacketBuffer dataStream) {
        this.allowDefault = dataStream.readBoolean();
        this.color = TransporterUtils.readColor(dataStream.func_150792_a());
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + (this.color != null ? this.color.ordinal() : -1);
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return filter instanceof TransporterFilter && ((TransporterFilter)filter).color == this.color;
    }
}

