/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.HashSet;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public final class InvStack {
    private final TileEntity tile;
    private final Direction side;
    private Int2IntMap itemMap = new Int2IntOpenHashMap();
    private HashedItem itemType;
    private int itemCount;

    public InvStack(TileEntity inv, Direction facing) {
        this.tile = inv;
        this.side = facing;
    }

    public InvStack(TileEntity inv, int slotID, ItemStack stack, Direction facing) {
        this(inv, stack, InvStack.getMap(slotID, stack), facing);
    }

    public InvStack(TileEntity inv, ItemStack stack, Int2IntMap idMap, Direction facing) {
        this.tile = inv;
        this.side = facing;
        this.itemMap = idMap;
        for (Int2IntMap.Entry entry : idMap.int2IntEntrySet()) {
            this.appendStack(entry.getIntKey(), StackUtils.size(stack, entry.getIntValue()));
        }
    }

    public ItemStack getStack() {
        if (this.itemType == null || this.itemCount == 0) {
            return ItemStack.field_190927_a;
        }
        return StackUtils.size(this.itemType.getStack(), this.itemCount);
    }

    public void appendStack(int id, ItemStack stack) {
        if (this.itemType == null) {
            this.itemType = new HashedItem(stack);
        }
        this.itemMap.put(id, stack.func_190916_E());
        this.itemCount += stack.func_190916_E();
    }

    private void use(int amount, TransitRequest.TransitResponse response) {
        IItemHandler handler = InventoryUtils.assertItemHandler("InvStack", this.tile, this.side);
        if (handler != null) {
            HashSet<Integer> emptySlots = new HashSet<Integer>();
            for (Int2IntMap.Entry entry : this.itemMap.int2IntEntrySet()) {
                int toUse = Math.min(amount, entry.getIntValue());
                ItemStack ret = handler.extractItem(entry.getIntKey(), toUse, false);
                boolean stackable = InventoryUtils.areItemsStackable(this.itemType.getStack(), ret);
                if (!stackable || ret.func_190916_E() != toUse) {
                    Mekanism.logger.warn("An inventory's returned content " + (!stackable ? "type" : "count") + " does not line up with InvStack's prediction.");
                    Mekanism.logger.warn("InvStack item: " + this.itemType.getStack() + ", ret: " + ret);
                    Mekanism.logger.warn("Tile: " + this.tile + " " + this.tile.func_174877_v());
                }
                amount -= toUse;
                if (response != null && response.use(entry.getIntKey(), toUse)) {
                    emptySlots.add(entry.getIntKey());
                }
                if (amount != 0) continue;
                return;
            }
            emptySlots.forEach(i -> response.removeSlot((int)i));
        }
    }

    public void use(TransitRequest.TransitResponse response) {
        this.use(response.getSendingAmount(), response);
    }

    public void useAll() {
        this.use(this.getStack().func_190916_E(), null);
    }

    public int getCount() {
        return this.itemCount;
    }

    private static Int2IntMap getMap(int slotID, ItemStack stack) {
        Int2IntOpenHashMap map = new Int2IntOpenHashMap();
        map.put(slotID, stack.func_190916_E());
        return map;
    }
}

