/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.heat;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ITileHeatHandler
extends IMekanismHeatHandler {
    default public void updateHeatCapacitors(@Nullable Direction side) {
        for (IHeatCapacitor capacitor : this.getHeatCapacitors(side)) {
            if (!(capacitor instanceof BasicHeatCapacitor)) continue;
            ((BasicHeatCapacitor)capacitor).update();
        }
    }

    @Nullable
    default public IHeatHandler getAdjacent(@Nullable Direction side) {
        return null;
    }

    default public HeatAPI.HeatTransfer simulate() {
        double adjacentTransfer = 0.0;
        double environmentTransfer = 0.0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            double tempToTransfer;
            double invConduction;
            IHeatHandler sink = this.getAdjacent(side);
            double heatCapacity = this.getTotalHeatCapacity(side);
            if (sink != null) {
                invConduction = sink.getTotalInverseConduction() + this.getTotalInverseConductionCoefficient(side);
                tempToTransfer = (this.getTotalTemperature(side) - 300.0) / invConduction;
                this.handleHeat(-tempToTransfer * heatCapacity, side);
                sink.handleHeat(tempToTransfer * heatCapacity);
                if (sink instanceof ICapabilityProvider && CapabilityUtils.getCapability((ICapabilityProvider)sink, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).filter(transmitter -> TransmissionType.checkTransmissionType(transmitter, TransmissionType.HEAT)).isPresent()) continue;
                adjacentTransfer += tempToTransfer;
                continue;
            }
            invConduction = 10000.0 + this.getTotalInverseInsulation(side) + this.getTotalInverseConductionCoefficient(side);
            tempToTransfer = (this.getTotalTemperature(side) - 300.0) / invConduction;
            this.handleHeat(-tempToTransfer * heatCapacity, side);
            environmentTransfer += tempToTransfer;
        }
        return new HeatAPI.HeatTransfer(adjacentTransfer, environmentTransfer);
    }
}

