/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;

@ParametersAreNonnullByDefault
public class RenderLogisticalTransporter
extends RenderTransmitterBase<TileEntityLogisticalTransporter> {
    private static Map<Direction, Int2ObjectMap<MekanismRenderer.Model3D>> cachedOverlays = new EnumMap<Direction, Int2ObjectMap<MekanismRenderer.Model3D>>(Direction.class);
    private static TextureAtlasSprite gunpowderIcon;
    private static TextureAtlasSprite torchOffIcon;
    private static TextureAtlasSprite torchOnIcon;
    private ModelTransporterBox modelBox = new ModelTransporterBox();
    private ItemEntity entityItem = new ItemEntity(EntityType.field_200765_E, null);
    private EntityRenderer<? super ItemEntity> renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entityItem);

    public RenderLogisticalTransporter(TileEntityRendererDispatcher renderer) {
        super(renderer);
        this.entityItem.func_174873_u();
    }

    public static void onStitch(AtlasTexture map) {
        cachedOverlays.clear();
        gunpowderIcon = map.func_195424_a(new ResourceLocation("minecraft", "item/gunpowder"));
        torchOffIcon = map.func_195424_a(new ResourceLocation("minecraft", "block/redstone_torch_off"));
        torchOnIcon = map.func_195424_a(new ResourceLocation("minecraft", "block/redstone_torch"));
    }

    @Override
    protected void render(TileEntityLogisticalTransporter transporter, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        BlockRayTraceResult rayTraceResult;
        ItemStack itemStack;
        Collection<TransporterStack> inTransit = transporter.getTransmitter().getTransit();
        BlockPos pos = transporter.func_174877_v();
        if (!inTransit.isEmpty()) {
            matrix.func_227860_a_();
            this.entityItem.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.entityItem.field_70170_p = transporter.func_145831_w();
            float partial = partialTick * (float)transporter.tier.getSpeed();
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                this.entityItem.func_92058_a(stack.itemStack);
                float[] stackPos = TransporterUtils.getStackPosition(transporter.getTransmitter(), stack, partial);
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)stackPos[0], (double)stackPos[1], (double)stackPos[2]);
                matrix.func_227862_a_(0.75f, 0.75f, 0.75f);
                this.renderer.func_225623_a_((Entity)this.entityItem, 0.0f, 0.0f, matrix, renderer, 0xF000F0);
                matrix.func_227865_b_();
                if (stack.color == null) continue;
                this.modelBox.render(matrix, renderer, 0xF000F0, overlayLight, stackPos[0], stackPos[1], stackPos[2], stack.color);
            }
            matrix.func_227865_b_();
        }
        if (transporter instanceof TileEntityDiversionTransporter && !(itemStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g()).func_190926_b() && itemStack.func_77973_b() instanceof ItemConfigurator && !(rayTraceResult = MekanismUtils.rayTrace((PlayerEntity)Minecraft.func_71410_x().field_71439_g)).func_216346_c().equals((Object)RayTraceResult.Type.MISS) && rayTraceResult.func_216350_a().equals((Object)pos)) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            int mode = ((TileEntityDiversionTransporter)transporter).modes[rayTraceResult.func_216354_b().ordinal()];
            MekanismRenderer.renderObject(this.getOverlayModel(rayTraceResult.func_216354_b(), mode), matrix, renderer.getBuffer(MekanismRenderType.resizableCuboid()), MekanismRenderer.getColorARGB(255, 255, 255, 0.8f), 0xF000F0);
            matrix.func_227865_b_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "logisticalTransporter";
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        ObjectOpenHashSet information = new ObjectOpenHashSet();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.func_190926_b() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private MekanismRenderer.Model3D getOverlayModel(Direction side, int mode) {
        if (cachedOverlays.containsKey(side) && cachedOverlays.get(side).containsKey(mode)) {
            return (MekanismRenderer.Model3D)cachedOverlays.get(side).get(mode);
        }
        TextureAtlasSprite icon = null;
        switch (mode) {
            case 0: {
                icon = gunpowderIcon;
                break;
            }
            case 1: {
                icon = torchOnIcon;
                break;
            }
            case 2: {
                icon = torchOffIcon;
            }
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(icon);
        switch (side) {
            case DOWN: {
                model.minY = -0.01;
                model.maxY = 0.0;
                model.minX = 0.0;
                model.minZ = 0.0;
                model.maxX = 1.0;
                model.maxZ = 1.0;
                break;
            }
            case UP: {
                model.minY = 1.0;
                model.maxY = 1.01;
                model.minX = 0.0;
                model.minZ = 0.0;
                model.maxX = 1.0;
                model.maxZ = 1.0;
                break;
            }
            case NORTH: {
                model.minZ = -0.01;
                model.maxZ = 0.0;
                model.minX = 0.0;
                model.minY = 0.0;
                model.maxX = 1.0;
                model.maxY = 1.0;
                break;
            }
            case SOUTH: {
                model.minZ = 1.0;
                model.maxZ = 1.01;
                model.minX = 0.0;
                model.minY = 0.0;
                model.maxX = 1.0;
                model.maxY = 1.0;
                break;
            }
            case WEST: {
                model.minX = -0.01;
                model.maxX = 0.0;
                model.minY = 0.0;
                model.minZ = 0.0;
                model.maxY = 1.0;
                model.maxZ = 1.0;
                break;
            }
            case EAST: {
                model.minX = 1.0;
                model.maxX = 1.01;
                model.minY = 0.0;
                model.minZ = 0.0;
                model.maxY = 1.0;
                model.maxZ = 1.0;
                break;
            }
        }
        if (cachedOverlays.containsKey(side)) {
            cachedOverlays.get(side).put(mode, (Object)model);
        } else {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            map.put(mode, (Object)model);
            cachedOverlays.put(side, (Int2ObjectMap<MekanismRenderer.Model3D>)map);
        }
        return model;
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = new HashedItem(transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TransportInformation) {
                TransportInformation other = (TransportInformation)obj;
                return this.progress == other.progress && this.color == other.color && this.item.equals(other.item);
            }
            return false;
        }
    }
}

