/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.data.ValveRenderData;

public final class ModelRenderer {
    private static final int BLOCK_STAGES = 1000;
    private static Map<RenderData, Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterData = new Object2ObjectOpenHashMap();
    private static Map<ValveRenderData, MekanismRenderer.Model3D> cachedValveFluids = new Object2ObjectOpenHashMap();

    public static MekanismRenderer.Model3D getModel(RenderData data, double scale) {
        Int2ObjectOpenHashMap cachedCenter;
        int maxStages = data.height * 1000;
        int stage = data.isGaseous() ? maxStages : Math.min(maxStages, (int)(scale * (double)maxStages));
        if (cachedCenterData.containsKey(data)) {
            cachedCenter = cachedCenterData.get(data);
            if (cachedCenter.containsKey(stage)) {
                return (MekanismRenderer.Model3D)cachedCenter.get(stage);
            }
        } else {
            cachedCenter = new Int2ObjectOpenHashMap();
            cachedCenterData.put(data, (Int2ObjectMap<MekanismRenderer.Model3D>)cachedCenter);
        }
        if (maxStages == 0) {
            stage = 1;
            maxStages = 1;
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(data.getTexture());
        cachedCenter.put(stage, (Object)model);
        model.minX = 0.01;
        model.minY = 0.01;
        model.minZ = 0.01;
        model.maxX = (double)data.length - 0.01;
        model.maxY = (double)((float)stage / (float)maxStages * (float)data.height) - 0.01;
        model.maxZ = (double)data.width - 0.01;
        return model;
    }

    public static MekanismRenderer.Model3D getValveModel(ValveRenderData data) {
        if (cachedValveFluids.containsKey(data)) {
            return cachedValveFluids.get(data);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        MekanismRenderer.prepFlowing(model, data.fluidType);
        cachedValveFluids.put(data, model);
        switch (data.side) {
            case DOWN: {
                model.minX = 0.3;
                model.minY = 1.01;
                model.minZ = 0.3;
                model.maxX = 0.7;
                model.maxY = 1.5;
                model.maxZ = 0.7;
                break;
            }
            case UP: {
                model.minX = 0.3;
                model.minY = (double)(-data.height) - 0.01;
                model.minZ = 0.3;
                model.maxX = 0.7;
                model.maxY = -0.01;
                model.maxZ = 0.7;
                break;
            }
            case NORTH: {
                model.minX = 0.3;
                model.minY = (double)(-ModelRenderer.getValveFluidHeight(data)) + 0.01;
                model.minZ = 1.02;
                model.maxX = 0.7;
                model.maxY = 0.7;
                model.maxZ = 1.4;
                break;
            }
            case SOUTH: {
                model.minX = 0.3;
                model.minY = (double)(-ModelRenderer.getValveFluidHeight(data)) + 0.01;
                model.minZ = -0.4;
                model.maxX = 0.7;
                model.maxY = 0.7;
                model.maxZ = -0.02;
                break;
            }
            case WEST: {
                model.minX = 1.02;
                model.minY = (double)(-ModelRenderer.getValveFluidHeight(data)) + 0.01;
                model.minZ = 0.3;
                model.maxX = 1.4;
                model.maxY = 0.7;
                model.maxZ = 0.7;
                break;
            }
            case EAST: {
                model.minX = -0.4;
                model.minY = (double)(-ModelRenderer.getValveFluidHeight(data)) + 0.01;
                model.minZ = 0.3;
                model.maxX = -0.02;
                model.maxY = 0.7;
                model.maxZ = 0.7;
                break;
            }
        }
        return model;
    }

    private static int getValveFluidHeight(ValveRenderData data) {
        return data.valveLocation.y - data.location.y;
    }

    public static void resetCachedModels() {
        cachedCenterData.clear();
        cachedValveFluids.clear();
    }
}

