/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiSideHolder;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public abstract class GuiInsetElement<TILE extends TileEntity>
extends GuiSideHolder {
    protected final int border;
    protected final int innerWidth;
    protected final int innerHeight;
    protected final TILE tile;
    protected final ResourceLocation overlay;

    public GuiInsetElement(ResourceLocation overlay, IGuiWrapper gui, TILE tile, int x, int y, int height, int innerSize) {
        super(gui, x, y, height);
        this.overlay = overlay;
        this.tile = tile;
        this.innerWidth = innerSize;
        this.innerHeight = innerSize;
        this.border = (this.width - this.innerWidth) / 2;
        this.playClickSound = true;
        this.active = true;
    }

    public boolean isMouseOver(double xAxis, double yAxis) {
        return this.active && this.visible && xAxis >= (double)(this.x + this.border) && xAxis < (double)(this.x + this.width - this.border) && yAxis >= (double)(this.y + this.border) && yAxis < (double)(this.y + this.height - this.border);
    }

    @Override
    protected int getButtonX() {
        return this.x + this.border + (this.left ? 1 : -1);
    }

    @Override
    protected int getButtonY() {
        return this.y + this.border;
    }

    @Override
    protected int getButtonWidth() {
        return this.innerWidth;
    }

    @Override
    protected int getButtonHeight() {
        return this.innerHeight;
    }

    protected ResourceLocation getOverlay() {
        return this.overlay;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        super.renderButton(mouseX, mouseY, partialTicks);
        this.drawButton(mouseX, mouseY);
        GuiInsetElement.minecraft.field_71446_o.func_110577_a(this.getOverlay());
        GuiInsetElement.blit((int)this.getButtonX(), (int)this.getButtonY(), (float)0.0f, (float)0.0f, (int)this.innerWidth, (int)this.innerHeight, (int)this.innerWidth, (int)this.innerHeight);
    }
}

