/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TurtleLandEntity
extends AnimalEntity {
    private static final Ingredient TURTLE_EDIBLE = Ingredient.func_199805_a(AquacultureAPI.Tags.TURTLE_EDIBLE);

    public TurtleLandEntity(EntityType<? extends AnimalEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new TurtleLandMovementController(this);
        this.func_184644_a(PathNodeType.WATER, 0.2f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new TurtleLandSwimGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.05));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.15, false, TURTLE_EDIBLE));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new GetOutOfWaterGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return TURTLE_EDIBLE.test(stack);
    }

    @Nullable
    public AgeableEntity func_90011_a(@Nonnull AgeableEntity ageableEntity) {
        return (AgeableEntity)this.func_200600_R().func_200721_a(this.field_70170_p);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_70631_g_() ? size.field_220316_b * 0.75f : size.field_220316_b * 0.7f;
    }

    static class GetOutOfWaterGoal
    extends MoveToBlockGoal {
        private final TurtleLandEntity turtle;

        private GetOutOfWaterGoal(TurtleLandEntity turtle) {
            super((CreatureEntity)turtle, turtle.func_70631_g_() ? 1.4 : 1.2, 24);
            this.turtle = turtle;
            this.field_203112_e = -1;
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        public boolean func_75253_b() {
            return this.turtle.func_70090_H() && this.field_179493_e <= 1200 && this.func_179488_a((IWorldReader)this.turtle.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            return this.turtle.func_70090_H() && super.func_75250_a();
        }

        protected boolean func_179488_a(IWorldReader reader, @Nonnull BlockPos pos) {
            Block block = reader.func_180495_p(pos).func_177230_c();
            return !(block instanceof FlowingFluidBlock);
        }
    }

    static class TurtleLandMovementController
    extends MovementController {
        private final TurtleLandEntity turtle;

        TurtleLandMovementController(TurtleLandEntity turtle) {
            super((MobEntity)turtle);
            this.turtle = turtle;
        }

        public void func_75641_c() {
            super.func_75641_c();
            this.updateSpeed();
        }

        private void updateSpeed() {
            if (this.turtle.func_70090_H()) {
                if (this.turtle.func_70631_g_()) {
                    this.turtle.func_70659_e(0.2f);
                } else {
                    this.turtle.func_70659_e(0.18f);
                }
            } else if (this.turtle.field_70122_E) {
                this.turtle.func_70659_e(0.1f);
            }
        }
    }

    public class TurtleLandSwimGoal
    extends SwimGoal {
        public TurtleLandSwimGoal() {
            super((MobEntity)TurtleLandEntity.this);
        }

        public boolean func_75250_a() {
            return TurtleLandEntity.this.func_70090_H() && TurtleLandEntity.this.func_212107_bY() > 0.1375 || TurtleLandEntity.this.func_180799_ab();
        }
    }
}

