/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.core.network.packet.server.SideConfigPacket;
import cofh.lib.util.Utils;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.control.IReconfigurableTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class ReconfigControlModule
implements IReconfigurable {
    protected IReconfigurableTile tile;
    protected boolean enabled;
    protected IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};

    public ReconfigControlModule(IReconfigurableTile tile) {
        this(tile, true);
    }

    public ReconfigControlModule(IReconfigurableTile tile, boolean enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public ReconfigControlModule setEnabled(IReconfigurableTile tile, boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public IReconfigurable.SideConfig[] getSideConfig() {
        return this.sides;
    }

    public void setSideConfig(IReconfigurable.SideConfig[] sides) {
        this.sides = sides;
    }

    public void readFromBuffer(PacketBuffer buffer) {
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = IReconfigurable.SideConfig.VALUES[buffer.readByte()];
        }
    }

    public void writeToBuffer(PacketBuffer buffer) {
        for (int i = 0; i < 6; ++i) {
            buffer.writeByte(this.sides[i].ordinal());
        }
    }

    public ReconfigControlModule read(CompoundNBT nbt) {
        byte[] bSides = nbt.func_74770_j("Sides");
        if (bSides.length == 6) {
            for (int i = 0; i < 6; ++i) {
                if (bSides[i] > IReconfigurable.SideConfig.VALUES.length) {
                    bSides[i] = 0;
                }
                this.sides[i] = IReconfigurable.SideConfig.VALUES[bSides[i]];
            }
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        byte[] bSides = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bSides[i] = (byte)this.sides[i].ordinal();
        }
        nbt.func_74773_a("Sides", bSides);
        return nbt;
    }

    public IReconfigurable.SideConfig getSideConfig(int side) {
        if (side > 5) {
            return IReconfigurable.SideConfig.SIDE_ACCESSIBLE;
        }
        return this.sides[side];
    }

    @Override
    public boolean isReconfigurable() {
        return this.enabled;
    }

    @Override
    public IReconfigurable.SideConfig getSideConfig(Direction side) {
        if (side == null || !this.isReconfigurable()) {
            return IReconfigurable.SideConfig.SIDE_ACCESSIBLE;
        }
        return this.sides[side.ordinal()];
    }

    @Override
    public boolean prevSideConfig(Direction side) {
        if (!this.isReconfigurable() || side == null) {
            return false;
        }
        this.sides[side.ordinal()] = this.sides[side.ordinal()].prev();
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean nextSideConfig(Direction side) {
        if (!this.isReconfigurable() || side == null) {
            return false;
        }
        this.sides[side.ordinal()] = this.sides[side.ordinal()].next();
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean setSideConfig(Direction side, IReconfigurable.SideConfig config) {
        if (!this.isReconfigurable() || side == null || config == null) {
            return false;
        }
        this.sides[side.ordinal()] = config;
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean clearAllSides() {
        this.sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean hasInputSide() {
        if (!this.isReconfigurable()) {
            return false;
        }
        for (IReconfigurable.SideConfig side : this.sides) {
            if (!side.isInput()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOutputSide() {
        if (!this.isReconfigurable()) {
            return false;
        }
        for (IReconfigurable.SideConfig side : this.sides) {
            if (!side.isOutput()) continue;
            return true;
        }
        return false;
    }
}

