/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChestWearItem
extends EquipmentItem {
    public ChestWearItem(ForgeMod mod, UnitConfig config, String name, Item.Properties props, int durability, UnitId repairItem, SoundEvent equipSound) {
        super(mod, config, name, props, durability, repairItem, EquipmentSlotType.CHEST, equipSound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInitClient() {
        for (Map.Entry e : Minecraft.func_71410_x().func_175598_ae().getSkinMap().entrySet()) {
            PlayerRenderer renderer = (PlayerRenderer)e.getValue();
            LayerChestWear layer = new LayerChestWear((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderer);
            renderer.func_177094_a((LayerRenderer)layer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LayerChestWear
    extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
        protected final ModelRenderer model;

        public LayerChestWear(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
            super(renderer);
            this.model = ((PlayerModel)renderer.func_217764_d()).field_178730_v;
        }

        public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
            if (stack.func_77973_b() instanceof ChestWearItem) {
                matrixStack.func_227860_a_();
                if (player.func_213453_ef()) {
                    matrixStack.func_227861_a_(0.0, (double)0.2f, 0.0);
                }
                if (player.func_70631_g_()) {
                    matrixStack.func_227861_a_(0.0, 0.5, 0.0);
                    matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
                    matrixStack.func_227861_a_(0.0, 16.0, 0.0);
                }
                int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
                this.model.func_228307_a_(matrixStack);
                this.model.func_228308_a_(matrixStack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)player.func_110306_p())), packedLight, packedOverlay);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.translatef((float)0.0f, (float)-0.25f, (float)0.0f);
                RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderSystem.scalef((float)0.625f, (float)-0.625f, (float)-0.625f);
                minecraft.func_175599_af().func_229109_a_((LivingEntity)player, stack, ItemCameraTransforms.TransformType.HEAD, false, matrixStack, buffer, player.field_70170_p, packedLight, packedOverlay);
                matrixStack.func_227865_b_();
            }
        }
    }
}

