/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ForgeMethodTransformer {
    public static final String HANDLE_METHOD_NAME = "handle";

    public static String instructToString(MethodInsnNode node) {
        return node.getClass().getSimpleName() + Args.group(Args.get("opcode", node.getOpcode()), Args.get("owner", node.owner), Args.get("name", node.name), Args.get("descriptor", node.desc));
    }

    public static String methodToString(MethodNode method) {
        return method.name + method.desc;
    }

    protected void logInfo(String msg, Object ... params) {
        String loggerName = this.getClass().getSimpleName();
        LogManager.getLogger((String)loggerName).debug(msg, params);
    }

    @Deprecated
    protected ClassNode getClassNode(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    @Deprecated
    protected byte[] getByteCode(ClassNode classNode) {
        int flags = 1;
        if (!this.isCompatibilityMode()) {
            flags = 2 | flags;
        }
        ClassWriter writer = new ClassWriter(flags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @Deprecated
    public boolean isCompatibilityMode() {
        return false;
    }

    protected MethodSignature getDefaultHandlerWith(MethodDescriptor descriptor) {
        return MethodSignature.of(this.getClass().getName(), HANDLE_METHOD_NAME, descriptor);
    }

    protected abstract MethodSignature getTargetMethod();

    protected abstract MethodSignature getHandler();

    protected abstract boolean isProperInstruction(MethodInsnNode var1);

    protected abstract boolean shouldSearchNextInstruction(MethodInsnNode var1);

    protected abstract void injectInstructions(InstructList var1);

    public String getTargetClassName() {
        return this.getTargetMethod().className.java;
    }

    public ClassNode transform(ClassNode clazz) {
        this.logInfo("Transforming class: {}", this.getTargetMethod().className);
        boolean result = false;
        this.logInfo("\tsearching method: {}", this.getTargetMethod().name);
        for (MethodNode method : clazz.methods) {
            if (!this.getTargetMethod().complyWith(method)) continue;
            this.logInfo("\ttransforming method: {}", ForgeMethodTransformer.methodToString(method));
            result = this.transformMethod(method);
            break;
        }
        this.logInfo("Transformation result: {}", result);
        return clazz;
    }

    protected boolean transformMethod(MethodNode method) {
        ListIterator iterator = method.instructions.iterator();
        boolean result = false;
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode instruct = (MethodInsnNode)node;
            if (this.isProperInstruction(instruct)) {
                this.logInfo("\t\tfound instruction: {}", ForgeMethodTransformer.instructToString(instruct));
                InstructList instructions = new InstructList(method, (AbstractInsnNode)instruct);
                this.injectInstructions(instructions);
                result = true;
                if (this.shouldSearchNextInstruction(instruct)) continue;
                break;
            }
            this.logInfo("\t\t--> {}", ForgeMethodTransformer.instructToString(instruct));
        }
        return result;
    }
}

