/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.enderio;

import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.InterModComms;

public class EnderIO
implements IThirdParty {
    @Override
    public void init() {
        this.registerFuel((Fluid)ModFluids.DIESEL.get());
        this.registerFuel((Fluid)ModFluids.KEROSENE.get());
        this.registerFuel((Fluid)ModFluids.GASOLINE.get());
        this.registerFuel((Fluid)ModFluids.LPG.get());
    }

    private void registerFuel(Fluid fluid) {
        IFuelRegistry api = PneumaticCraftAPIHandler.getInstance().getFuelRegistry();
        float burnTime = api.getBurnRateMultiplier(fluid) * 60.0f;
        this.registerFuel(fluid, (int)burnTime, api.getFuelValue(fluid) / (int)burnTime);
    }

    private void registerFuel(Fluid fluid, int powerPerCycle, int burnTime) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("fluidName", fluid.getRegistryName().toString());
        tag.func_74768_a("powerPerCycle", powerPerCycle);
        tag.func_74768_a("totalBurnTime", burnTime);
        InterModComms.sendTo((String)"enderio", (String)"fluidFuel:add", () -> tag);
    }

    @Override
    public void postInit() {
        IThirdParty.registerFuel("enderio:hootch", 360000);
        IThirdParty.registerFuel("enderio:rocket_fuel", 0x111700);
        IThirdParty.registerFuel("enderio:fire_water", 1200000);
    }
}

