/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.curios;

import java.util.Map;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public class Curios
implements IThirdParty {
    public static boolean available = false;
    public static final Pair<String, Integer> NONE = Pair.of((Object)"", (Object)-1);

    @Override
    public void init() {
        available = true;
    }

    public static void chargeItems(PlayerEntity player, PneumaticEnergyStorage energyStorage, int maxTransfer) {
        CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getCurioMap().forEach((id, stackHandler) -> {
            for (int i = 0; i < stackHandler.getSlots() && energyStorage.getEnergyStored() > 0; ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(receivingStorage -> {
                    int energyLeft = energyStorage.getEnergyStored();
                    energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(energyLeft, maxTransfer), false), false);
                });
            }
        }));
    }

    public static ItemStack getStack(PlayerEntity player, String invId, int slot) {
        return (ItemStack)CuriosAPI.getCuriosHandler((LivingEntity)player).map(handler -> {
            CurioStackHandler h = (CurioStackHandler)handler.getCurioMap().get(invId);
            return h == null ? ItemStack.field_190927_a : h.getStackInSlot(slot);
        }).orElse((Object)ItemStack.field_190927_a);
    }

    public static Pair<String, Integer> findStack(PlayerEntity player, Predicate<ItemStack> predicate) {
        return (Pair)CuriosAPI.getCuriosHandler((LivingEntity)player).map(handler -> {
            for (Map.Entry entry : handler.getCurioMap().entrySet()) {
                for (int i = 0; i < ((CurioStackHandler)entry.getValue()).getSlots(); ++i) {
                    if (!predicate.test(((CurioStackHandler)entry.getValue()).getStackInSlot(i))) continue;
                    return Pair.of(entry.getKey(), (Object)i);
                }
            }
            return NONE;
        }).orElse(NONE);
    }

    public static void setupSideConfigurator(SideConfigurator<IItemHandler> configurator, PlayerEntity player) {
        if (player != null) {
            CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getCurioMap().forEach((id, stackHandler) -> configurator.registerHandler("curios_" + id, CuriosAPI.getIcon((String)id), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, () -> stackHandler, new SideConfigurator.RelativeFace[0])));
        } else {
            configurator.unregisterHandlers(s -> s.startsWith("curios_"));
        }
    }

    public static IItemHandler makeCombinedInvWrapper(PlayerEntity player) {
        return (IItemHandler)CuriosAPI.getCuriosHandler((LivingEntity)player).map(handler -> new CombinedInvWrapper(handler.getCurioMap().values().toArray(new IItemHandlerModifiable[0]))).orElse((Object)new CombinedInvWrapper(new IItemHandlerModifiable[0]));
    }
}

