/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncDroneEntityProgWidgets {
    private List<IProgWidget> progWidgets;
    private int entityId;

    public PacketSyncDroneEntityProgWidgets() {
    }

    public PacketSyncDroneEntityProgWidgets(EntityDrone drone) {
        this.progWidgets = drone.getProgWidgets();
        this.entityId = drone.func_145782_y();
    }

    PacketSyncDroneEntityProgWidgets(PacketBuffer buffer) {
        this.progWidgets = TileEntityProgrammer.getWidgetsFromNBT(buffer.func_150793_b());
        this.entityId = buffer.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150786_a(TileEntityProgrammer.putWidgetsToNBT(this.progWidgets, new CompoundNBT()));
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = ClientUtils.getClientWorld().func_73045_a(this.entityId);
            if (entity instanceof EntityDrone) {
                EntityDrone drone = (EntityDrone)entity;
                List<IProgWidget> widgets = drone.getProgWidgets();
                widgets.clear();
                widgets.addAll(this.progWidgets);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

