/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;

public class ContainerRemote
extends ContainerPneumaticBase<TileEntityBase> {
    private final List<String> syncedVars;
    private final BlockPos[] lastValues;
    private final Hand hand;
    public String[] variables = new String[0];

    public ContainerRemote(ContainerType<? extends ContainerRemote> type, int windowId, PlayerInventory playerInventory, Hand hand) {
        super(type, windowId, playerInventory);
        this.hand = hand;
        this.syncedVars = new ArrayList<String>(ContainerRemote.getRelevantVariableNames(playerInventory.field_70458_d.func_184586_b(hand)));
        this.lastValues = new BlockPos[this.syncedVars.size()];
    }

    private ContainerRemote(ContainerType<ContainerRemote> type, int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(type, windowId, playerInventory, ContainerRemote.getHandFromBuffer(buffer));
    }

    public static ContainerRemote createRemoteContainer(int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new ContainerRemote((ContainerType<ContainerRemote>)((ContainerType)ModContainers.REMOTE.get()), windowId, playerInventory, buffer);
    }

    public static ContainerRemote createRemoteEditorContainer(int windowId, PlayerInventory playerInventory, PacketBuffer buffer) {
        return new ContainerRemote((ContainerType<ContainerRemote>)((ContainerType)ModContainers.REMOTE_EDITOR.get()), windowId, playerInventory, buffer);
    }

    private static Hand getHandFromBuffer(PacketBuffer buffer) {
        return buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    private static Set<String> getRelevantVariableNames(@Nonnull ItemStack remote) {
        HashSet<String> variables = new HashSet<String>();
        CompoundNBT tag = remote.func_77978_p();
        if (tag != null) {
            ListNBT tagList = tag.func_150295_c("actionWidgets", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT widgetTag = tagList.func_150305_b(i);
                variables.add(widgetTag.func_74779_i("variableName"));
                variables.add(widgetTag.func_74779_i("enableVariable"));
                TextVariableParser parser = new TextVariableParser(widgetTag.func_74779_i("text"));
                parser.parse();
                variables.addAll(parser.getRelevantVariables());
            }
        }
        return variables;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.lastValues.length; ++i) {
            BlockPos newValue = GlobalVariableManager.getInstance().getPos(this.syncedVars.get(i));
            if (newValue.equals((Object)this.lastValues[i])) continue;
            this.lastValues[i] = newValue;
            for (Object o : this.field_75149_d) {
                if (!(o instanceof ServerPlayerEntity)) continue;
                NetworkHandler.sendToPlayer(new PacketSetGlobalVariable(this.syncedVars.get(i), newValue), (ServerPlayerEntity)o);
            }
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return player.func_184586_b(this.hand).func_77973_b() == ModItems.REMOTE.get();
    }

    public Hand getHand() {
        return this.hand;
    }
}

