/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import java.io.File;
import java.io.IOException;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.config.subconfig.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.config.subconfig.ThirdPartyConfig;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraftforge.fml.loading.FMLPaths;

public class AuxConfigHandler {
    private static final IAuxConfig[] EXTERNAL_CONFIGS = new IAuxConfig[]{AmadronPlayerOffers.INSTANCE, ProgWidgetConfig.INSTANCE, ArmorFeatureStatus.INSTANCE, ThirdPartyConfig.INSTANCE, MicromissileDefaults.INSTANCE, ArmorHUDLayout.INSTANCE};

    public static void preInit() {
        File configDir = FMLPaths.CONFIGDIR.get().toFile();
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            File subFolder = new File(configDir, "pneumaticcraft");
            if (!subFolder.exists() && !subFolder.mkdirs()) continue;
            File subFile = new File(subFolder, subConfig.getConfigFilename() + ".cfg");
            try {
                subConfig.preInit(subFile);
            }
            catch (IOException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " failed to create! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " appears to be invalid JSON! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public static void postInit() {
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            try {
                subConfig.postInit();
            }
            catch (IOException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " failed to create! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " appears to be invalid JSON! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
        }
    }
}

