/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.ClientSetup;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetKeybindCheckBox
extends WidgetCheckBox
implements ITooltipProvider {
    public static final String UPGRADE_PREFIX = "pneumaticHelmet.upgrade.";
    private static WidgetKeybindCheckBox coreComponents;
    private final String upgradeID;
    private boolean isAwaitingKey;
    private String oldCheckboxText;
    private KeyBinding keyBinding;

    public WidgetKeybindCheckBox(int x, int y, int color, String upgradeID, Consumer<WidgetCheckBox> pressable) {
        super(x, y, color, I18n.func_135052_a((String)"gui.enableModule", (Object[])new Object[]{I18n.func_135052_a((String)(UPGRADE_PREFIX + upgradeID), (Object[])new Object[0])}), pressable);
        this.upgradeID = upgradeID;
        this.keyBinding = this.findSavedKeybind();
        if (!KeyDispatcher.id2checkBox.containsKey(upgradeID)) {
            this.checked = ArmorFeatureStatus.INSTANCE.isUpgradeEnabled(upgradeID);
            if (this.keyBinding != null) {
                KeyDispatcher.dispatchMap.put(this.keyBinding, this);
            }
            KeyDispatcher.id2checkBox.put(this.upgradeID, this);
            if (upgradeID.equals("coreComponents")) {
                coreComponents = this;
            }
        } else {
            this.checked = ((WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get((Object)upgradeID)).checked;
        }
    }

    private KeyBinding makeKeyBinding(int keyCode, KeyModifier modifier) {
        return new KeyBinding(UPGRADE_PREFIX + this.upgradeID, (IKeyConflictContext)KeyConflictContext.IN_GAME, modifier, InputMappings.Type.KEYSYM, keyCode, "key.pneumaticcraft.category");
    }

    public static WidgetKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    public static WidgetKeybindCheckBox fromKeyBindingName(String name) {
        return (WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get(name);
    }

    public static boolean isHandlerEnabled(IUpgradeRenderHandler handler) {
        return WidgetKeybindCheckBox.fromKeyBindingName((String)handler.getUpgradeID()).checked;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.clicked(x, y)) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.handleClick(x, y, button);
            return true;
        }
        return false;
    }

    private void handleClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            super.onClick(mouseX, mouseY);
            ArmorFeatureStatus.INSTANCE.setUpgradeEnabled(this.upgradeID, this.checked);
            ((WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get((Object)this.upgradeID)).checked = this.checked;
            try {
                ArmorFeatureStatus.INSTANCE.writeToFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CommonArmorHandler hudHandler = CommonArmorHandler.getHandlerForPlayer();
            for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                int i;
                List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
                for (i = 0; i < renderHandlers.size(); ++i) {
                    IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                    if (!upgradeRenderHandler.getUpgradeID().equals(this.upgradeID) || !hudHandler.isUpgradeRendererInserted(slot, i)) continue;
                    NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, WidgetKeybindCheckBox.coreComponents.checked && this.checked, slot));
                    hudHandler.setUpgradeRenderEnabled(slot, (byte)i, WidgetKeybindCheckBox.coreComponents.checked && this.checked);
                    HUDHandler.instance().addFeatureToggleMessage(UPGRADE_PREFIX + this.upgradeID, this.checked);
                    break;
                }
                if (!this.upgradeID.equals("coreComponents")) continue;
                for (i = 0; i < renderHandlers.size(); ++i) {
                    boolean state = WidgetKeybindCheckBox.fromKeyBindingName((String)renderHandlers.get((int)i).getUpgradeID()).checked;
                    NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, WidgetKeybindCheckBox.coreComponents.checked && state, slot));
                    hudHandler.setUpgradeRenderEnabled(slot, (byte)i, WidgetKeybindCheckBox.coreComponents.checked && state);
                }
            }
        } else if (button == 1) {
            if (Screen.hasShiftDown()) {
                this.clearKeybinding();
            } else {
                boolean bl = this.isAwaitingKey = !this.isAwaitingKey;
                if (this.isAwaitingKey) {
                    this.oldCheckboxText = this.getMessage();
                    this.setMessage(I18n.func_135052_a((String)"gui.setKeybind", (Object[])new Object[0]));
                } else {
                    this.setMessage(this.oldCheckboxText);
                }
            }
        }
    }

    private void clearKeybinding() {
        if (this.keyBinding != null) {
            KeyDispatcher.dispatchMap.remove(this.keyBinding);
        }
        KeyBinding[] keyBindings = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        HashSet<Integer> idx = new HashSet<Integer>();
        for (int i = 0; i < keyBindings.length; ++i) {
            if (!keyBindings[i].func_151464_g().equals(this.keyBinding.func_151464_g())) continue;
            idx.add(i);
            break;
        }
        if (!idx.isEmpty()) {
            ArrayList<KeyBinding> l = new ArrayList<KeyBinding>(keyBindings.length);
            for (int i = 0; i < keyBindings.length; ++i) {
                if (idx.contains(i)) continue;
                l.add(keyBindings[i]);
            }
            Minecraft.func_71410_x().field_71474_y.field_74324_K = l.toArray(new KeyBinding[0]);
            this.keyBinding = this.makeKeyBinding(-1, KeyModifier.NONE);
            ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
            KeyBinding.func_74508_b();
            ClientSetup.keybindToKeyCodes.put(this.upgradeID, (Pair<Integer, KeyModifier>)Pair.of((Object)-1, (Object)KeyModifier.NONE));
            Minecraft.func_71410_x().field_71474_y.func_74303_b();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isAwaitingKey) {
            InputMappings.Input input = InputMappings.Type.KEYSYM.func_197944_a(keyCode);
            if (KeyModifier.isKeyCodeModifier((InputMappings.Input)input)) {
                return true;
            }
            this.isAwaitingKey = false;
            this.keyBinding = this.setOrAddKeybind(keyCode, KeyModifier.getActiveModifier());
            KeyDispatcher.dispatchMap.put(this.keyBinding, WidgetKeybindCheckBox.fromKeyBindingName(this.upgradeID));
            this.setMessage(this.oldCheckboxText);
            return true;
        }
        return false;
    }

    private KeyBinding findSavedKeybind() {
        return this.setOrAddKeybind(-1, KeyModifier.NONE);
    }

    private KeyBinding setOrAddKeybind(int keyCode, KeyModifier modifier) {
        String keybindName = UPGRADE_PREFIX + this.upgradeID;
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        for (KeyBinding keyBinding : gameSettings.field_74324_K) {
            if (keyBinding == null || !keyBinding.func_151464_g().equals(keybindName)) continue;
            if (keyCode >= 0) {
                keyBinding.setKeyModifierAndCode(modifier, InputMappings.Type.KEYSYM.func_197944_a(keyCode));
                KeyBinding.func_74508_b();
                gameSettings.func_74303_b();
            }
            return keyBinding;
        }
        if (keyCode < 0) {
            if (ClientSetup.keybindToKeyCodes.containsKey(keybindName)) {
                Pair<Integer, KeyModifier> binding = ClientSetup.keybindToKeyCodes.get(keybindName);
                keyCode = (Integer)binding.getLeft();
                modifier = (KeyModifier)binding.getRight();
            } else {
                return null;
            }
        }
        KeyBinding keyBinding = this.makeKeyBinding(keyCode, modifier);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        KeyBinding.func_74508_b();
        gameSettings.func_74303_b();
        return keyBinding;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTooltip, boolean shiftPressed) {
        if (this.keyBinding != null) {
            String s = this.keyBinding.getKeyModifier() != KeyModifier.NONE ? this.keyBinding.getKeyModifier() + " + " : "";
            curTooltip.add(I18n.func_135052_a((String)"gui.keybindBoundKey", (Object[])new Object[]{s + I18n.func_135052_a((String)this.keyBinding.getKey().func_197935_d(), (Object[])new Object[0])}));
        }
        if (!this.isAwaitingKey) {
            curTooltip.add("gui.keybindRightClickToSet");
            if (this.keyBinding != null && this.keyBinding.getKey().func_197937_c() != -1) {
                curTooltip.add("gui.keybindShiftRightClickToClear");
            }
        }
    }

    private static class KeyBindMap
    extends Object2ObjectOpenCustomHashMap<KeyBinding, WidgetKeybindCheckBox> {
        KeyBindMap() {
            super((Hash.Strategy)new Hash.Strategy<KeyBinding>(){

                public int hashCode(KeyBinding o) {
                    return o == null ? 0 : Objects.hash(o.getKey().func_197937_c(), KeyBindMap.keyModifierToInt(o.getKeyModifier()));
                }

                public boolean equals(KeyBinding a, KeyBinding b) {
                    if (a == null || b == null) {
                        return false;
                    }
                    return a.getKeyModifier() == b.getKeyModifier() && a.getKey().func_197937_c() == b.getKey().func_197937_c();
                }
            });
        }

        private static int keyModifierToInt(KeyModifier km) {
            switch (km) {
                case SHIFT: {
                    return 1;
                }
                case CONTROL: {
                    return 2;
                }
                case ALT: {
                    return 4;
                }
            }
            return 0;
        }

        private static KeyModifier intToKeyModifier(int i) {
            if ((i & 1) != 0) {
                return KeyModifier.SHIFT;
            }
            if ((i & 2) != 0) {
                return KeyModifier.CONTROL;
            }
            if ((i & 4) != 0) {
                return KeyModifier.ALT;
            }
            return KeyModifier.NONE;
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyDispatcher {
        private static final Map<String, WidgetKeybindCheckBox> id2checkBox = new HashMap<String, WidgetKeybindCheckBox>();
        private static final Map<KeyBinding, WidgetKeybindCheckBox> dispatchMap = new KeyBindMap();

        @SubscribeEvent
        public static void onKeyPress(InputEvent.KeyInputEvent event) {
            KeyBinding synthetic;
            WidgetKeybindCheckBox cb;
            if (event.getAction() == 1 && (cb = dispatchMap.get(synthetic = new KeyBinding("synthetic", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyBindMap.intToKeyModifier(event.getModifiers()), InputMappings.Type.KEYSYM, event.getKey(), "key.pneumaticcraft.category"))) != null) {
                cb.handleClick(0.0, 0.0, 0);
            }
        }
    }
}

