/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerThermalCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityThermalCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiThermalCompressor
extends GuiPneumaticContainerBase<ContainerThermalCompressor, TileEntityThermalCompressor> {
    public GuiThermalCompressor(ContainerThermalCompressor container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new WidgetTemperatureSided(Direction.NORTH, 63));
        this.addButton(new WidgetTemperatureSided(Direction.SOUTH, 73));
        this.addButton(new WidgetTemperatureSided(Direction.WEST, 88));
        this.addButton(new WidgetTemperatureSided(Direction.EAST, 98));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_THERMAL_COMPRESSOR;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        return new PointXY(xStart + (int)((double)this.field_146999_f * 0.82), yStart + this.field_147000_g / 4 + 4);
    }

    private int getTemperatureDifferential(Direction side) {
        int temp1 = ((IHeatExchangerLogic)((TileEntityThermalCompressor)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).orElseThrow(RuntimeException::new)).getTemperatureAsInt();
        int temp2 = ((IHeatExchangerLogic)((TileEntityThermalCompressor)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side.func_176734_d()).orElseThrow(RuntimeException::new)).getTemperatureAsInt();
        return Math.abs(temp1 - temp2);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        double prod = ((TileEntityThermalCompressor)this.te).airProduced(Direction.NORTH) + ((TileEntityThermalCompressor)this.te).airProduced(Direction.EAST);
        if (prod > 0.0 && this.redstoneAllows) {
            pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.tooltip.producingAir", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(prod, 1)}));
        }
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (this.getTemperatureDifferential(Direction.NORTH) < 10 && this.getTemperatureDifferential(Direction.EAST) < 10) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.thermal_compressor.no_temp_diff", (Object[])new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        int dns = this.getTemperatureDifferential(Direction.NORTH);
        int dew = this.getTemperatureDifferential(Direction.EAST);
        if (dns < 20 && dew >= 10 && dew < 20 || dew < 20 && dns >= 10 && dns < 20) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.thermal_compressor.poor_temp_diff", (Object[])new Object[0]));
        }
    }

    private class WidgetTemperatureSided
    extends WidgetTemperature {
        private final Direction side;

        WidgetTemperatureSided(Direction side, int x) {
            super(GuiThermalCompressor.this.field_147003_i + x, GuiThermalCompressor.this.field_147009_r + 20, 0, 2000, ((TileEntityThermalCompressor)GuiThermalCompressor.this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side), new int[0]);
            this.side = side;
        }

        @Override
        public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
            int temp = (Integer)this.logic.map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
            curTip.add(HeatUtil.formatHeatString(this.side, temp).func_150254_d());
        }
    }
}

