/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.torchslabsmod.blocks.buzzierbees.entities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FallingCandleSlabEntity
extends Entity {
    private BlockState fallTile = Blocks.field_150354_m.func_176223_P();
    public int fallTime;
    public boolean shouldDropItem = true;
    private boolean dontSetBlock;
    private boolean hurtEntities;
    private int fallHurtMax = 40;
    private float fallHurtAmount = 2.0f;
    public CompoundNBT tileEntityData;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(FallingBlockEntity.class, (IDataSerializer)DataSerializers.field_187200_j);

    public FallingCandleSlabEntity(EntityType<? extends FallingBlockEntity> p_i50218_1_, World p_i50218_2_) {
        super(p_i50218_1_, p_i50218_2_);
    }

    public FallingCandleSlabEntity(World worldIn, double x, double y, double z, BlockState fallingBlockState) {
        this((EntityType<? extends FallingBlockEntity>)EntityType.field_200809_w, worldIn);
        this.fallTile = fallingBlockState;
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setOrigin(new BlockPos((Entity)this));
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setOrigin(BlockPos p_184530_1_) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)p_184530_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        int i;
        if (this.hurtEntities && (i = MathHelper.func_76123_f((float)(p_225503_1_ - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            boolean flag = this.fallTile.func_203425_a(BlockTags.field_200572_k);
            DamageSource damagesource = flag ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount)), this.fallHurtMax));
            }
            if (flag && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                BlockState blockstate = AnvilBlock.func_196433_f((BlockState)this.fallTile);
                if (blockstate == null) {
                    this.dontSetBlock = true;
                } else {
                    this.fallTile = blockstate;
                }
            }
        }
        return false;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.fallTile));
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74757_a("DropItem", this.shouldDropItem);
        compound.func_74757_a("HurtEntities", this.hurtEntities);
        compound.func_74776_a("FallHurtAmount", this.fallHurtAmount);
        compound.func_74768_a("FallHurtMax", this.fallHurtMax);
        if (this.tileEntityData != null) {
            compound.func_218657_a("TileEntityData", (INBT)this.tileEntityData);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.fallTile = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("HurtEntities", 99)) {
            this.hurtEntities = compound.func_74767_n("HurtEntities");
            this.fallHurtAmount = compound.func_74760_g("FallHurtAmount");
            this.fallHurtMax = compound.func_74762_e("FallHurtMax");
        } else if (this.fallTile.func_203425_a(BlockTags.field_200572_k)) {
            this.hurtEntities = true;
        }
        if (compound.func_150297_b("DropItem", 99)) {
            this.shouldDropItem = compound.func_74767_n("DropItem");
        }
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = compound.func_74775_l("TileEntityData");
        }
        if (this.fallTile.func_196958_f()) {
            this.fallTile = Blocks.field_150354_m.func_176223_P();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public World getWorldObj() {
        return this.field_70170_p;
    }

    public void setHurtEntities(boolean hurtEntitiesIn) {
        this.hurtEntities = hurtEntitiesIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Immitating BlockState", (Object)this.fallTile.toString());
    }

    public BlockState getBlockState() {
        return this.fallTile;
    }

    public boolean func_184213_bq() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this, Block.func_196246_j((BlockState)this.getBlockState()));
    }
}

