/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.TieredItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.ContainerEnchantmentExt;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.altar.BlockPrismaticAltar;
import shadows.apotheosis.ench.altar.TilePrismaticAltar;
import shadows.apotheosis.ench.anvil.BlockAnvilExt;
import shadows.apotheosis.ench.anvil.EnchantmentSplitting;
import shadows.apotheosis.ench.anvil.ItemAnvilExt;
import shadows.apotheosis.ench.anvil.TileAnvil;
import shadows.apotheosis.ench.enchantments.EnchantmentBerserk;
import shadows.apotheosis.ench.enchantments.EnchantmentDepths;
import shadows.apotheosis.ench.enchantments.EnchantmentHellInfused;
import shadows.apotheosis.ench.enchantments.EnchantmentIcyThorns;
import shadows.apotheosis.ench.enchantments.EnchantmentKnowledge;
import shadows.apotheosis.ench.enchantments.EnchantmentLifeMend;
import shadows.apotheosis.ench.enchantments.EnchantmentMagicProt;
import shadows.apotheosis.ench.enchantments.EnchantmentMounted;
import shadows.apotheosis.ench.enchantments.EnchantmentNatureBless;
import shadows.apotheosis.ench.enchantments.EnchantmentRebounding;
import shadows.apotheosis.ench.enchantments.EnchantmentReflective;
import shadows.apotheosis.ench.enchantments.EnchantmentScavenger;
import shadows.apotheosis.ench.enchantments.EnchantmentShieldBash;
import shadows.apotheosis.ench.enchantments.EnchantmentStableFooting;
import shadows.apotheosis.ench.enchantments.EnchantmentTempting;
import shadows.apotheosis.ench.objects.BlockHellBookshelf;
import shadows.apotheosis.ench.objects.ItemHellBookshelf;
import shadows.apotheosis.ench.objects.ItemScrapTome;
import shadows.apotheosis.ench.objects.ItemShearsExt;
import shadows.apotheosis.ench.objects.ItemTypedBook;
import shadows.placebo.config.Configuration;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.recipe.NBTIngredient;
import shadows.placebo.util.ReflectionHelper;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<ItemTypedBook> TYPED_BOOKS = new LinkedList<ItemTypedBook>();
    public static final DamageSource CORRUPTED = new DamageSource("apoth_corrupted").func_76348_h().func_151518_m();
    public static final EquipmentSlotType[] ARMOR = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public static final EnchantmentType HOE = EnchantmentType.create((String)"HOE", i -> i instanceof HoeItem);
    public static final EnchantmentType SHIELD = EnchantmentType.create((String)"SHIELD", i -> i instanceof ShieldItem);
    public static final EnchantmentType ANVIL = EnchantmentType.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).func_179223_d() instanceof AnvilBlock);
    static Configuration enchInfoConfig;
    public static int absMax;
    public static boolean allowWeb;
    public static float maxNormalPower;
    public static float maxPower;
    public static boolean itemMerging;
    Method dropLoot;
    final EquipmentSlotType[] slots = EquipmentSlotType.values();

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisSetup e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "enchantability.cfg"));
        EnchModule.setEnch(ItemTier.GOLD, 40);
        EnchModule.setEnch(ArmorMaterial.GOLD, 40);
        if (config.hasChanged()) {
            config.save();
        }
        config = new Configuration(new File(Apotheosis.configDir, "enchantment_module.cfg"));
        allowWeb = config.getBoolean("Enable Cobwebs", "general", allowWeb, "If cobwebs can be used in anvils to remove enchantments.");
        maxNormalPower = config.getFloat("Max Normal Power", "general", maxNormalPower, 0.0f, Float.MAX_VALUE, "The maximum enchantment power a table can receive from normal sources.");
        maxPower = config.getFloat("Max Power", "general", maxPower, 0.0f, Float.MAX_VALUE, "The maximum enchantment power a table can receive.");
        itemMerging = config.getBoolean("Item Merging", "general", false, "If any two enchanted items can be combined in an Anvil.");
        if (config.hasChanged()) {
            config.save();
        }
        EnchModule.recalcAbsMax();
        config = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            String minF;
            int max = config.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment.");
            int min = config.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > max) {
                min = max;
            }
            EnchantmentInfo info = new EnchantmentInfo(ench, max, min);
            String maxF = config.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = config.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
        }
        if (config.hasChanged()) {
            config.save();
        }
        enchInfoConfig = config;
        NBTIngredient pot = new NBTIngredient(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185220_C));
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.HELLSHELF, 3, 3, new Object[]{Blocks.field_196653_dH, Blocks.field_196653_dH, Blocks.field_196653_dH, Items.field_151072_bj, "forge:bookshelves", pot, Blocks.field_196653_dH, Blocks.field_196653_dH, Blocks.field_196653_dH});
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.field_179562_cC, null, Items.field_179562_cC, Blocks.field_196553_aF, Items.field_179562_cC, null, Items.field_179562_cC, null});
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        ItemStack stick = new ItemStack((IItemProvider)Items.field_151055_y);
        ItemStack blaze = new ItemStack((IItemProvider)Items.field_151072_bj);
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_HEAD_BOOK, 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_CHEST_BOOK, 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_LEGS_BOOK, 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.ARMOR_FEET_BOOK, 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.WEAPON_BOOK, 2), 1, 3, new Object[]{book, book, new ItemStack((IItemProvider)Items.field_151065_br)});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.DIGGER_BOOK, 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.FISHING_ROD_BOOK, 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.BOW_BOOK, 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
        Apotheosis.HELPER.addShapeless((Object)new ItemStack((IItemProvider)ApotheosisObjects.NULL_BOOK, 6), new Object[]{book, book, book, book, book, book, blaze});
        ItemStack msBrick = new ItemStack((IItemProvider)Blocks.field_196698_dj);
        Apotheosis.HELPER.addShaped((Object)ApotheosisObjects.PRISMATIC_ALTAR, 3, 3, new Object[]{msBrick, null, msBrick, msBrick, Items.field_205158_fa, msBrick, msBrick, Blocks.field_150381_bn, msBrick});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)Items.field_151062_by, 16), 3, 3, new Object[]{Items.field_151061_bv, Items.field_151074_bl, Items.field_151061_bv, Items.field_151065_br, Items.field_185157_bK, Items.field_151065_br, Items.field_151114_aO, Items.field_151114_aO, Items.field_151114_aO});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)Items.field_151062_by, 1), 3, 3, new Object[]{Items.field_151061_bv, Blocks.field_150340_R, Items.field_151061_bv, Items.field_151072_bj, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b), Items.field_151072_bj, Blocks.field_150426_aN, Blocks.field_150426_aN, Blocks.field_150426_aN});
        Apotheosis.HELPER.addShaped((Object)new ItemStack((IItemProvider)ApotheosisObjects.SCRAP_TOME, 8), 3, 3, new Object[]{book, book, book, book, Blocks.field_150467_bQ, book, book, book, book});
        LootSystem.defaultBlockTable((Block)ApotheosisObjects.PRISMATIC_ALTAR);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.error("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)ench.getRegistryName(), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().register(new TileEntityType(TileAnvil::new, (Set)ImmutableSet.of((Object)Blocks.field_150467_bQ, (Object)Blocks.field_196717_eY, (Object)Blocks.field_196718_eZ), null).setRegistryName("anvil"));
        e.getRegistry().register(new TileEntityType(TilePrismaticAltar::new, (Set)ImmutableSet.of((Object)((Object)ApotheosisObjects.PRISMATIC_ALTAR)), null).setRegistryName("prismatic_altar"));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockHellBookshelf().setRegistryName("hellshelf"), (Block)new BlockPrismaticAltar().setRegistryName("apotheosis", "prismatic_altar"), (Block)new BlockAnvilExt().setRegistryName("minecraft", "anvil"), (Block)new BlockAnvilExt().setRegistryName("minecraft", "chipped_anvil"), (Block)new BlockAnvilExt().setRegistryName("minecraft", "damaged_anvil")});
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        Item oldShears = Items.field_151097_aZ;
        Item[] itemArray = new Item[17];
        ItemShearsExt shears = new ItemShearsExt();
        itemArray[0] = shears;
        itemArray[1] = (Item)new ItemHellBookshelf(ApotheosisObjects.HELLSHELF).setRegistryName(ApotheosisObjects.HELLSHELF.getRegistryName());
        itemArray[2] = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("apotheosis", "prismatic_web");
        itemArray[3] = new ItemAnvilExt(Blocks.field_150467_bQ);
        itemArray[4] = new ItemAnvilExt(Blocks.field_196717_eY);
        itemArray[5] = new ItemAnvilExt(Blocks.field_196718_eZ);
        itemArray[6] = new ItemTypedBook(Items.field_190931_a, null);
        itemArray[7] = new ItemTypedBook(Items.field_151161_ac, EnchantmentType.ARMOR_HEAD);
        itemArray[8] = new ItemTypedBook(Items.field_151163_ad, EnchantmentType.ARMOR_CHEST);
        itemArray[9] = new ItemTypedBook(Items.field_151173_ae, EnchantmentType.ARMOR_LEGS);
        itemArray[10] = new ItemTypedBook(Items.field_151175_af, EnchantmentType.ARMOR_FEET);
        itemArray[11] = new ItemTypedBook(Items.field_151048_u, EnchantmentType.WEAPON);
        itemArray[12] = new ItemTypedBook(Items.field_151046_w, EnchantmentType.DIGGER);
        itemArray[13] = new ItemTypedBook(Items.field_151112_aM, EnchantmentType.FISHING_ROD);
        itemArray[14] = new ItemTypedBook(Items.field_151031_f, EnchantmentType.BOW);
        itemArray[15] = (Item)new BlockItem((Block)ApotheosisObjects.PRISMATIC_ALTAR, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("prismatic_altar");
        itemArray[16] = new ItemScrapTome();
        e.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
        DispenserBlock.func_199774_a((IItemProvider)shears, (IDispenseItemBehavior)((IDispenseItemBehavior)DispenserBlock.field_149943_a.get(oldShears)));
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new EnchantmentHellInfused().setRegistryName("apotheosis", "hell_infusion"), (Enchantment)new EnchantmentMounted().setRegistryName("apotheosis", "mounted_strike"), (Enchantment)new EnchantmentDepths().setRegistryName("apotheosis", "depth_miner"), (Enchantment)new EnchantmentStableFooting().setRegistryName("apotheosis", "stable_footing"), (Enchantment)new EnchantmentScavenger().setRegistryName("apotheosis", "scavenger"), (Enchantment)new EnchantmentLifeMend().setRegistryName("apotheosis", "life_mending"), (Enchantment)new EnchantmentIcyThorns().setRegistryName("apotheosis", "icy_thorns"), (Enchantment)new EnchantmentTempting().setRegistryName("apotheosis", "tempting"), (Enchantment)new EnchantmentShieldBash().setRegistryName("apotheosis", "shield_bash"), (Enchantment)new EnchantmentReflective().setRegistryName("apotheosis", "reflective"), (Enchantment)new EnchantmentBerserk().setRegistryName("apotheosis", "berserk"), (Enchantment)new EnchantmentKnowledge().setRegistryName("apotheosis", "knowledge"), (Enchantment)new EnchantmentSplitting().setRegistryName("apotheosis", "splitting"), (Enchantment)new EnchantmentNatureBless().setRegistryName("apotheosis", "natures_blessing"), (Enchantment)new EnchantmentRebounding().setRegistryName("apotheosis", "rebounding"), (Enchantment)new EnchantmentMagicProt().setRegistryName("apotheosis", "magic_protection")});
    }

    @SubscribeEvent
    public void sounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().register(new SoundEvent(new ResourceLocation("apotheosis", "altar")).setRegistryName("apotheosis", "altar_sound"));
    }

    @SubscribeEvent
    public void anvilEvent(AnvilUpdateEvent e) {
        if (!EnchantmentHelper.func_82781_a((ItemStack)e.getLeft()).isEmpty()) {
            if (allowWeb && e.getRight().func_77973_b() == Items.field_221672_ax) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> ((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(ent -> (Enchantment)ent.getKey(), ent -> (Integer)ent.getValue())), (ItemStack)stack);
                e.setCost(1);
                e.setMaterialCost(1);
                e.setOutput(stack);
            } else if (e.getRight().func_77973_b() == ApotheosisObjects.PRISMATIC_WEB) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> !((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(ent -> (Enchantment)ent.getKey(), ent -> (Integer)ent.getValue())), (ItemStack)stack);
                e.setCost(30);
                e.setMaterialCost(1);
                e.setOutput(stack);
                return;
            }
        }
        if ((e.getLeft().func_77973_b() == Items.field_221846_eg || e.getLeft().func_77973_b() == Items.field_221848_eh) && e.getRight().func_77973_b().func_206844_a(Tags.Items.STORAGE_BLOCKS_IRON)) {
            int dmg;
            int n = dmg = e.getLeft().func_77973_b() == Items.field_221848_eh ? 2 : 1;
            if (e.getLeft().func_190916_E() != 1) {
                return;
            }
            ItemStack out = new ItemStack((IItemProvider)(dmg == 1 ? Items.field_221844_ef : Items.field_221846_eg));
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)e.getLeft()), (ItemStack)out);
            out.func_190920_e(1);
            e.setOutput(out);
            e.setCost(5 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getLeft()) * 2 + EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SPLITTING, (ItemStack)e.getLeft()) * 3);
            e.setMaterialCost(1);
            return;
        }
        if (ItemTypedBook.updateAnvil(e)) {
            return;
        }
        if (ItemScrapTome.updateAnvil(e)) {
            return;
        }
        if (itemMerging && this.mergeAll(e)) {
            return;
        }
    }

    private boolean mergeAll(AnvilUpdateEvent ev) {
        ItemStack right = ev.getRight();
        ItemStack left = ev.getLeft();
        if (!right.func_77948_v() || !left.func_77973_b().func_77616_k(left)) {
            return false;
        }
        Map rightEnch = EnchantmentHelper.func_82781_a((ItemStack)right);
        Map leftEnch = EnchantmentHelper.func_82781_a((ItemStack)left);
        int cost = 0;
        for (Enchantment ench : rightEnch.keySet()) {
            int curLevel;
            if (ench == null) continue;
            int level = (Integer)rightEnch.get(ench);
            int n = curLevel = leftEnch.containsKey(ench) ? (Integer)leftEnch.get(ench) : 0;
            if (level > 0 && level == curLevel) {
                level = Math.min(EnchModule.getEnchInfo(ench).getMaxLevel(), level + 1);
            }
            if (curLevel > level) {
                level = curLevel;
            }
            if (!ench.func_92089_a(left)) continue;
            boolean isCompat = true;
            for (Enchantment ench2 : leftEnch.keySet()) {
                if (ench == ench2 || ench.func_191560_c(ench2)) continue;
                isCompat = false;
            }
            if (!isCompat) {
                return false;
            }
            leftEnch.put(ench, level);
            int addition = 0;
            switch (ench.func_77324_c()) {
                case COMMON: {
                    addition += 2 * level;
                    break;
                }
                case UNCOMMON: {
                    addition += 4 * level;
                    break;
                }
                case RARE: {
                    addition += 6 * level;
                    break;
                }
                case VERY_RARE: {
                    addition += 12 * level;
                }
            }
            cost += Math.max(1, addition / 2);
        }
        if (cost > 0) {
            ItemStack out = left.func_77946_l();
            out.func_82841_c(left.func_82838_A() * 2 + 1);
            EnchantmentHelper.func_82782_a((Map)leftEnch, (ItemStack)out);
            ev.setMaterialCost(1);
            ev.setCost(cost += left.func_82838_A());
            ev.setOutput(out);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) throws Exception {
        Entity attacker = e.getSource().func_76346_g();
        if (attacker instanceof PlayerEntity) {
            int knowledge;
            PlayerEntity p = (PlayerEntity)attacker;
            if (p.field_70170_p.field_72995_K) {
                return;
            }
            int scavenger = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SCAVENGER, (ItemStack)p.func_184614_ca());
            if (scavenger > 0 && (float)p.field_70170_p.field_73012_v.nextInt(100) < (float)scavenger * 2.5f) {
                if (this.dropLoot == null) {
                    this.dropLoot = ReflectionHelper.findMethod(LivingEntity.class, (String)"dropLoot", (String)"func_213354_a", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
                }
                this.dropLoot.invoke((Object)e.getEntityLiving(), e.getSource(), true);
            }
            if ((knowledge = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.KNOWLEDGE, (ItemStack)p.func_184614_ca())) > 0 && !(e.getEntity() instanceof PlayerEntity)) {
                int items = 0;
                for (ItemEntity i : e.getDrops()) {
                    items += i.func_92059_d().func_190916_E();
                }
                if (items > 0) {
                    e.getDrops().clear();
                }
                items *= knowledge * 25;
                LivingEntity ded = e.getEntityLiving();
                while (items > 0) {
                    int i = ExperienceOrbEntity.func_70527_a((int)items);
                    items -= i;
                    p.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(p.field_70170_p, ded.func_226277_ct_(), ded.func_226278_cu_(), ded.func_226281_cx_(), i));
                }
            }
        }
    }

    @SubscribeEvent
    public void lifeMend(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        for (EquipmentSlotType slot : this.slots) {
            int level;
            ItemStack stack = e.getEntityLiving().func_184582_a(slot);
            if (stack.func_190926_b() || !stack.func_77951_h() || (level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.LIFE_MENDING, (ItemStack)stack)) <= 0 || e.getEntityLiving().field_70170_p.field_73012_v.nextInt(10) != 0) continue;
            int i = Math.min(level, stack.func_77952_i());
            e.getEntityLiving().func_70097_a(CORRUPTED, (float)i * 0.7f);
            stack.func_196085_b(stack.func_77952_i() - i);
            return;
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        ItemStack stack;
        PlayerEntity p = e.getPlayer();
        if (!p.field_70122_E && EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.STABLE_FOOTING, (LivingEntity)p) > 0 && e.getOriginalSpeed() < e.getNewSpeed() * 5.0f) {
            e.setNewSpeed(e.getNewSpeed() * 5.0f);
        }
        if ((stack = p.func_184614_ca()).func_190926_b()) {
            return;
        }
        int depth = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.DEPTH_MINER, (ItemStack)stack);
        if (depth > 0) {
            if (!stack.getToolTypes().stream().anyMatch(arg_0 -> ((BlockState)e.getState()).isToolEffective(arg_0))) {
                return;
            }
            float effectiveness = ((float)p.field_70170_p.func_181545_F() - (float)p.func_226278_cu_()) / (float)p.field_70170_p.func_181545_F();
            if (effectiveness < 0.0f) {
                effectiveness /= 3.0f;
            }
            float speedChange = 1.0f + (float)(depth * 5) * effectiveness;
            e.setNewSpeed(Math.max(0.05f, e.getNewSpeed() + speedChange));
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        ItemStack s = e.getItemStack();
        int nbLevel = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.NATURES_BLESSING, (ItemStack)s);
        if (!e.getEntity().func_225608_bj_() && nbLevel > 0 && BoneMealItem.applyBonemeal((ItemStack)s.func_77946_l(), (World)e.getWorld(), (BlockPos)e.getPos(), (PlayerEntity)e.getPlayer())) {
            s.func_222118_a(6 - nbLevel, (LivingEntity)e.getPlayer(), ent -> ent.func_213334_d(e.getHand()));
            e.setCanceled(true);
            e.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void applyUnbreaking(AnvilRepairEvent e) {
        if (e.getPlayer().field_71070_bA instanceof RepairContainer) {
            RepairContainer r = (RepairContainer)e.getPlayer().field_71070_bA;
            TileEntity te = r.field_216980_g.func_221484_a((w, p) -> w.func_175625_s(p)).orElse(null);
            if (te instanceof TileAnvil) {
                e.setBreakChance(e.getBreakChance() / (float)(((TileAnvil)te).getUnbreaking() + 1));
            }
        }
    }

    @SubscribeEvent
    public void enchLevel(EnchantmentLevelSetEvent e) {
        int power = e.getPower();
        e.setLevel(Math.max(e.getEnchantRow() + 1, MathHelper.func_76141_d((float)((float)power * (1.0f + (float)e.getEnchantRow() * 0.5f)))));
    }

    @SubscribeEvent
    public void enchContainer(PlayerContainerEvent.Open e) {
        if (!e.getEntity().field_70170_p.field_72995_K && e.getContainer().getClass() == EnchantmentContainer.class) {
            EnchantmentContainer old = (EnchantmentContainer)e.getContainer();
            ContainerEnchantmentExt newC = new ContainerEnchantmentExt(old.field_75152_c, e.getPlayer().field_71071_by, old.field_217006_g);
            newC.func_75132_a((IContainerListener)((ServerPlayerEntity)e.getEntity()));
            e.getPlayer().field_71070_bA = newC;
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent e) {
        LivingEntity src;
        int lvl;
        int level;
        LivingEntity user = e.getEntityLiving();
        if (e.getSource().func_76346_g() instanceof Entity && user.func_70660_b(Effects.field_76429_m) == null && (level = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.BERSERK, (LivingEntity)user)) > 0) {
            user.func_70097_a(CORRUPTED, (float)(level * level));
            user.func_195064_c(new EffectInstance(Effects.field_76429_m, 200 * level, level - 1));
            user.func_195064_c(new EffectInstance(Effects.field_76420_g, 200 * level, level - 1));
            user.func_195064_c(new EffectInstance(Effects.field_76424_c, 200 * level, level - 1));
        }
        if (e.getSource().func_82725_o() && e.getSource().func_76346_g() instanceof LivingEntity && (lvl = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.MAGIC_PROTECTION, (LivingEntity)(src = (LivingEntity)e.getSource().func_76346_g()))) > 0) {
            e.setAmount(CombatRules.func_188401_b((float)e.getAmount(), (float)EnchantmentHelper.func_77508_a((Iterable)src.func_184193_aE(), (DamageSource)e.getSource())));
        }
    }

    public static void setEnch(ItemTier mat, int ench) {
        ReflectionHelper.setPrivateValue(ItemTier.class, (Object)mat, (Object)ench, (String[])new String[]{"enchantability", "field_78008_j"});
    }

    public static void setEnch(ArmorMaterial mat, int ench) {
        ReflectionHelper.setPrivateValue(ArmorMaterial.class, (Object)mat, (Object)ench, (String[])new String[]{"enchantability", "field_78055_h"});
    }

    public static Set<IItemTier> getAllTiers() {
        HashSet<IItemTier> tiers = new HashSet<IItemTier>();
        for (Item i : ForgeRegistries.ITEMS) {
            if (!(i instanceof TieredItem)) continue;
            tiers.add(((TieredItem)i).func_200891_e());
        }
        return tiers;
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, e -> new EnchantmentInfo((Enchantment)e, e.func_77325_b(), e.func_77319_d()));
        }
        if (enchInfoConfig == null) {
            LOGGER.error("A mod has attempted to access enchantment information before Apotheosis init, this should not happen.");
            Thread.dumpStack();
            return new EnchantmentInfo(ench, ench.func_77325_b(), ench.func_77319_d());
        }
        if (info == null) {
            String minF;
            int max = enchInfoConfig.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment.");
            int min = enchInfoConfig.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > max) {
                min = max;
            }
            info = new EnchantmentInfo(ench, max, min);
            String maxF = enchInfoConfig.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = enchInfoConfig.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ench.getRegistryName(), (Object)ench.getRegistryName().func_110624_b());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.func_77325_b();
        if (level == 1) {
            return 1;
        }
        int maxPower = ench.func_223551_b(level);
        if (maxPower >= absMax) {
            return level;
        }
        int lastMaxPower = maxPower;
        while (maxPower < absMax) {
            if (lastMaxPower == (maxPower = ench.func_223551_b(++level))) {
                --level;
                break;
            }
            lastMaxPower = maxPower;
        }
        return level;
    }

    static void recalcAbsMax() {
        int max = MathHelper.func_76123_f((float)(maxPower * 2.0f));
        int maxEnch = 0;
        for (IItemTier m : EnchModule.getAllTiers()) {
            maxEnch = Math.max(maxEnch, m.func_200927_e());
        }
        for (ArmorMaterial m : ArmorMaterial.values()) {
            maxEnch = Math.max(maxEnch, m.func_200900_a());
        }
        absMax = max + maxEnch / 2 + 3;
    }

    static {
        absMax = 170;
        allowWeb = true;
        maxNormalPower = 20.0f;
        maxPower = 75.0f;
        itemMerging = false;
    }
}

