/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container.addon;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class SlotContainerAddon
implements IContainerAddon {
    private final IItemHandler itemHandler;
    private final int xPos;
    private final int yPos;
    private final Function<Integer, Pair<Integer, Integer>> positionFunction;

    public SlotContainerAddon(IItemHandler itemHandler, int xPos, int yPos, Function<Integer, Pair<Integer, Integer>> positionFunction) {
        this.itemHandler = itemHandler;
        this.xPos = xPos;
        this.yPos = yPos;
        this.positionFunction = positionFunction;
    }

    @Override
    public List<Slot> getSlots() {
        ArrayList slots = Lists.newArrayList();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            Pair<Integer, Integer> offset = this.positionFunction.apply(i);
            slots.add(new SlotItemHandler(this.itemHandler, i, this.xPos + (Integer)offset.getLeft(), this.yPos + (Integer)offset.getRight()));
        }
        return slots;
    }
}

