/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.compat;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.modules.generator.CoalGeneratorSetup;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellBlock;
import mcjty.rftoolspower.modules.powercell.data.SideType;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class RFToolsPowerTOPDriver
implements TOPDriver {
    public static final RFToolsPowerTOPDriver DRIVER = new RFToolsPowerTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = blockState.func_177230_c().getRegistryName();
        if (!this.drivers.containsKey(id)) {
            if (blockState.func_177230_c() == CoalGeneratorSetup.COALGENERATOR.get()) {
                this.drivers.put(id, new CoalDriver());
            } else if (blockState.func_177230_c() instanceof PowerCellBlock) {
                this.drivers.put(id, new PowerCellDriver());
            } else if (blockState.func_177230_c() instanceof DimensionalCellBlock) {
                this.drivers.put(id, new DimensionalCellDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class DimensionalCellDriver
    implements TOPDriver {
        private DimensionalCellDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                int id = te.getNetworkId();
                if (mode == ProbeMode.EXTENDED) {
                    if (id != -1) {
                        probeInfo.text(TextFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(id));
                    } else {
                        probeInfo.text(TextFormatting.GREEN + "Local storage!");
                    }
                }
                float costFactor = te.getCostFactor();
                int rfPerTick = te.getRfPerTickPerSide();
                probeInfo.text(TextFormatting.GREEN + "Input/Output: " + rfPerTick + " RF/t");
                DimensionalCellTileEntity.Mode powermode = te.getMode(data.getSideHit());
                if (powermode == DimensionalCellTileEntity.Mode.MODE_INPUT) {
                    probeInfo.text(TextFormatting.YELLOW + "Side: input");
                } else if (powermode == DimensionalCellTileEntity.Mode.MODE_OUTPUT) {
                    int cost = (int)((costFactor - 1.0f) * 1000.0f);
                    probeInfo.text(TextFormatting.YELLOW + "Side: output (cost " + cost / 10 + "." + cost % 10 + "%)");
                }
                if (mode == ProbeMode.EXTENDED) {
                    int rfPerTickIn = te.getLastRfPerTickIn();
                    int rfPerTickOut = te.getLastRfPerTickOut();
                    probeInfo.text(TextFormatting.GREEN + "In:  " + rfPerTickIn + "RF/t");
                    probeInfo.text(TextFormatting.GREEN + "Out: " + rfPerTickOut + "RF/t");
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class PowerCellDriver
    implements TOPDriver {
        private PowerCellDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                long rfPerTick = te.getRfPerTickReal();
                if (te.getNetwork().isValid()) {
                    probeInfo.text(TextFormatting.GREEN + "Input/Output: " + rfPerTick + " RF/t");
                    SideType powermode = te.getMode(data.getSideHit());
                    if (powermode == SideType.INPUT) {
                        probeInfo.text(TextFormatting.YELLOW + "Side: input");
                    } else if (powermode == SideType.OUTPUT) {
                        probeInfo.text(TextFormatting.YELLOW + "Side: output");
                    }
                } else {
                    probeInfo.text(TextStyleClass.ERROR + "Too many blocks in network (max " + PowerCellConfig.NETWORK_MAX.get() + ")!");
                }
                int networkId = te.getNetwork().getNetworkId();
                if (mode == ProbeMode.DEBUG) {
                    probeInfo.text(TextStyleClass.LABEL + "Network ID: " + TextStyleClass.INFO + networkId);
                }
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(TextStyleClass.LABEL + "Local Energy: " + TextStyleClass.INFO + te.getLocalEnergy());
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class CoalDriver
    implements TOPDriver {
        private CoalDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.func_175625_s(data.getPos()), te -> {
                Boolean working = te.isWorking();
                if (working.booleanValue()) {
                    probeInfo.text(TextFormatting.GREEN + "Producing " + te.getRfPerTick() + " RF/t");
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

