/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.common.base.Preconditions;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;

public abstract class ModelFile {
    protected ResourceLocation location;

    protected ModelFile(ResourceLocation location) {
        this.location = location;
    }

    protected abstract boolean exists();

    public ResourceLocation getLocation() {
        this.assertExistence();
        return this.location;
    }

    public void assertExistence() {
        Preconditions.checkState((boolean)this.exists(), (String)"Model at %s does not exist", (Object)this.location);
    }

    public ResourceLocation getUncheckedLocation() {
        return this.location;
    }

    public static class ExistingModelFile
    extends ModelFile {
        private final ExistingFileHelper existingHelper;

        public ExistingModelFile(ResourceLocation location, ExistingFileHelper existingHelper) {
            super(location);
            this.existingHelper = existingHelper;
        }

        @Override
        protected boolean exists() {
            if (this.getUncheckedLocation().func_110623_a().contains(".")) {
                return this.existingHelper.exists(this.getUncheckedLocation(), ResourcePackType.CLIENT_RESOURCES, "", "models");
            }
            return this.existingHelper.exists(this.getUncheckedLocation(), ResourcePackType.CLIENT_RESOURCES, ".json", "models");
        }
    }

    public static class UncheckedModelFile
    extends ModelFile {
        public UncheckedModelFile(String location) {
            this(new ResourceLocation(location));
        }

        public UncheckedModelFile(ResourceLocation location) {
            super(location);
        }

        @Override
        protected boolean exists() {
            return true;
        }
    }
}

