/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.component;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentID;
import java.util.Map;

public class ComponentRegistry {
    private static ComponentRegistry INST;
    private Map<ComponentID, Component> registry = Maps.newHashMap();

    public static ComponentRegistry getInstance() {
        if (INST == null) {
            INST = new ComponentRegistry();
        }
        return INST;
    }

    private ComponentRegistry() {
    }

    public void register(Component component) {
        if (this.registry.containsKey(component.getID())) {
            throw new RuntimeException("Component already exists under the id: " + component.getID().toString() + " Please use an alternative ID.");
        }
        this.registry.put(component.getID(), component);
    }

    public boolean isRegistered(Component component) {
        if (component == null) {
            return false;
        }
        return this.registry.containsValue(component);
    }

    public boolean isRegistered(ComponentID componentID) {
        if (componentID == null) {
            return false;
        }
        return this.registry.containsKey(componentID);
    }

    public Component getComponent(ComponentID componentID) {
        if (componentID == null) {
            throw new NullPointerException("ComponentID provided was null");
        }
        return this.registry.get(componentID);
    }
}

