/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.multiblock.Structure;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StructureList {
    protected LinkedHashMap<Integer, Structure> structures = Maps.newLinkedHashMap();
    protected LinkedHashMap<Integer, String> idToUnlocalized = Maps.newLinkedHashMap();
    protected int total;

    public StructureList(Structure ... structures) {
        if (structures.length <= 0) {
            throw new NullPointerException("StructureList was provided with zero Structures. Must have at least 1 Structure to be valid.");
        }
        for (Structure str : structures) {
            this.structures.put(this.total, str);
            this.idToUnlocalized.put(this.total, str.getUnlocalizedName());
            ++this.total;
        }
    }

    public Structure getStructure(int id) {
        return this.structures.get(MathUtil.clamp(id, 0, this.total));
    }

    public String getUnlocalizedName(int id) {
        return this.idToUnlocalized.get(MathUtil.clamp(id, 0, this.total));
    }

    public Map<Integer, String> getIDToUnlocalized() {
        return this.idToUnlocalized;
    }

    public int getTotal() {
        return this.total;
    }

    public List<Integer> getIDList() {
        LinkedList ids = Lists.newLinkedList();
        for (int i = 0; i < this.total; ++i) {
            ids.add(i);
        }
        return ids;
    }
}

