/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.theme.client.DefaultTheme;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.util.lambda.Action1a;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ThemeRegistryClient
extends ThemeRegistry {
    private static ThemeRegistryClient INST;
    protected DefaultTheme defaultTheme;
    protected Map<ThemeID, Theme> themeMap = Maps.newConcurrentMap();
    protected Map<ThemeID, List<Action1a<Theme.ThemeAssetContainer>>> themeAssetRegistries = Maps.newConcurrentMap();

    public static ThemeRegistryClient getInstance() {
        if (INST == null) {
            INST = new ThemeRegistryClient();
        }
        return INST;
    }

    @Override
    public void createTheme(ThemeID theme) {
        if (theme != null && !this.themeMap.containsKey(theme)) {
            this.themeMap.put(theme, new Theme(theme, this));
        }
    }

    public Theme getTheme(ThemeID themeID) {
        if (themeID == null || themeID == DEFAULT) {
            return this.defaultTheme;
        }
        if (this.themeMap.containsKey(themeID)) {
            return this.themeMap.get(themeID);
        }
        return this.defaultTheme;
    }

    public ThemeID getDefault() {
        return DEFAULT;
    }

    public void addThemeAssetContainer(ThemeID id, Action1a<Theme.ThemeAssetContainer> themeAssetRegistry) {
        if (id != null) {
            System.out.println("Registering Asset Container: " + id + " " + themeAssetRegistry);
            List<Object> containerList = this.themeAssetRegistries.containsKey(id) ? this.themeAssetRegistries.get(id) : Lists.newCopyOnWriteArrayList();
            if (themeAssetRegistry != null) {
                containerList.add(themeAssetRegistry);
            }
            this.themeAssetRegistries.put(id, containerList);
        }
    }

    public void reloadThemes() {
        System.out.println("RELOADING THEME REGISTRY");
        for (Theme t : this.themeMap.values()) {
            t.boxMap.clear();
            t.colorMap.clear();
            t.textureMap.clear();
        }
        this.defaultTheme = new DefaultTheme(DEFAULT, this);
        Theme.ThemeAssetContainer defaultContainer = Theme.ThemeAssetContainer.create(DEFAULT, this);
        this.processAssetRegistries(DEFAULT, defaultContainer);
        ThemeRegistryClient.registerThemeAssets(this.defaultTheme, defaultContainer);
        for (ThemeID tid : this.themeMap.keySet()) {
            Theme theme = this.themeMap.get(tid);
            Theme.ThemeAssetContainer container = Theme.ThemeAssetContainer.create(tid, this);
            this.processAssetRegistries(tid, container);
            ThemeRegistryClient.registerThemeAssets(theme, container);
        }
    }

    private void processAssetRegistries(ThemeID tid, Theme.ThemeAssetContainer container) {
        List containerList = this.themeAssetRegistries.getOrDefault(tid, new CopyOnWriteArrayList());
        for (Action1a act : containerList) {
            act.execute(container);
        }
    }

    private static void registerThemeAssets(Theme theme, Theme.ThemeAssetContainer registry) {
        theme.boxMap.putAll(registry.boxMap);
        theme.colorMap.putAll(registry.colorMap);
        theme.textureMap.putAll(registry.textureMap);
    }
}

