/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class ThreadDownloadImageData
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private final BufferedImage imageBuffer;
    @Nullable
    private BufferedImage bufferedImage;
    @Nullable
    private Thread imageThread;
    private boolean textureUploaded;
    private static final IntBuffer DATA_BUFFER = ThreadDownloadImageData.createDirectIntBuffer(0x400000);

    public ThreadDownloadImageData(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable BufferedImage imageBufferIn) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.imageBuffer = imageBufferIn;
    }

    private void checkTextureUploaded() {
        if (!this.textureUploaded && this.bufferedImage != null) {
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            ThreadDownloadImageData.uploadTextureImage(super.func_110552_b(), this.bufferedImage);
            this.textureUploaded = true;
        }
    }

    public int func_110552_b() {
        this.checkTextureUploaded();
        return super.func_110552_b();
    }

    public void setBufferedImage(BufferedImage bufferedImageIn) {
        this.bufferedImage = bufferedImageIn;
    }

    public void func_195413_a(IResourceManager resourceManager) throws IOException {
        if (this.bufferedImage == null && this.field_110568_b != null) {
            super.func_195413_a(resourceManager);
        }
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                try {
                    this.bufferedImage = ImageIO.read(this.cacheFile);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Couldn't load skin {}", (Object)this.cacheFile, (Object)ioexception);
                    this.loadTextureFromServer();
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                LOGGER.debug("Downloading http texture from {} to {}", (Object)ThreadDownloadImageData.this.imageUrl, (Object)ThreadDownloadImageData.this.cacheFile);
                try {
                    httpurlconnection = (HttpURLConnection)new URL(ThreadDownloadImageData.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        BufferedImage bufferedimage;
                        if (ThreadDownloadImageData.this.cacheFile != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ThreadDownloadImageData.this.cacheFile);
                            bufferedimage = ImageIO.read(ThreadDownloadImageData.this.cacheFile);
                        } else {
                            bufferedimage = ThreadDownloadImageData.readBufferedImage(httpurlconnection.getInputStream());
                        }
                        ThreadDownloadImageData.this.setBufferedImage(bufferedimage);
                        return;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
        return bufferedimage;
    }

    public static int uploadTextureImage(int textureId, BufferedImage texture) {
        return ThreadDownloadImageData.uploadTextureImageAllocate(textureId, texture, false, false);
    }

    public static int uploadTextureImageAllocate(int textureId, BufferedImage texture, boolean blur, boolean clamp) {
        ThreadDownloadImageData.allocateTexture(textureId, texture.getWidth(), texture.getHeight());
        return ThreadDownloadImageData.uploadTextureImageSub(textureId, texture, 0, 0, blur, clamp);
    }

    public static void allocateTexture(int textureId, int width, int height) {
        ThreadDownloadImageData.allocateTextureImpl(textureId, 0, width, height);
    }

    public static void allocateTextureImpl(int glTextureId, int mipmapLevels, int width, int height) {
        ThreadDownloadImageData.deleteTexture(glTextureId);
        ThreadDownloadImageData.bindTexture(glTextureId);
        if (mipmapLevels >= 0) {
            GlStateManager.func_227677_b_((int)3553, (int)33085, (int)mipmapLevels);
            GlStateManager.func_227677_b_((int)3553, (int)33082, (int)0);
            GlStateManager.func_227677_b_((int)3553, (int)33083, (int)mipmapLevels);
            GlStateManager.func_227642_a_((int)3553, (int)34049, (float)0.0f);
        }
        for (int i = 0; i <= mipmapLevels; ++i) {
            GlStateManager.func_227647_a_((int)3553, (int)i, (int)6408, (int)(width >> i), (int)(height >> i), (int)0, (int)32993, (int)33639, (IntBuffer)null);
        }
    }

    public static void deleteTexture(int textureId) {
        GlStateManager.func_227758_s_((int)textureId);
    }

    static void bindTexture(int p_94277_0_) {
        GlStateManager.func_227760_t_((int)p_94277_0_);
    }

    public static int uploadTextureImageSub(int textureId, BufferedImage p_110995_1_, int p_110995_2_, int p_110995_3_, boolean p_110995_4_, boolean p_110995_5_) {
        ThreadDownloadImageData.bindTexture(textureId);
        ThreadDownloadImageData.uploadTextureImageSubImpl(p_110995_1_, p_110995_2_, p_110995_3_, p_110995_4_, p_110995_5_);
        return textureId;
    }

    private static void uploadTextureImageSubImpl(BufferedImage p_110993_0_, int p_110993_1_, int p_110993_2_, boolean p_110993_3_, boolean p_110993_4_) {
        int i = p_110993_0_.getWidth();
        int j = p_110993_0_.getHeight();
        int k = 0x400000 / i;
        int[] aint = new int[k * i];
        ThreadDownloadImageData.setTextureBlurred(p_110993_3_);
        ThreadDownloadImageData.setTextureClamped(p_110993_4_);
        for (int l = 0; l < i * j; l += i * k) {
            int i1 = l / i;
            int j1 = Math.min(k, j - i1);
            int k1 = i * j1;
            p_110993_0_.getRGB(0, i1, i, j1, aint, 0, i);
            ThreadDownloadImageData.copyToBuffer(aint, k1);
            GlStateManager.func_227646_a_((int)3553, (int)0, (int)p_110993_1_, (int)(p_110993_2_ + i1), (int)i, (int)j1, (int)32993, (int)33639, (long)MemoryUtil.memAddress((IntBuffer)DATA_BUFFER));
        }
    }

    private static void setTextureBlurred(boolean p_147951_0_) {
        ThreadDownloadImageData.setTextureBlurMipmap(p_147951_0_, false);
    }

    private static void setTextureBlurMipmap(boolean p_147954_0_, boolean p_147954_1_) {
        if (p_147954_0_) {
            GlStateManager.func_227677_b_((int)3553, (int)10241, (int)(p_147954_1_ ? 9987 : 9729));
            GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9729);
        } else {
            GlStateManager.func_227677_b_((int)3553, (int)10241, (int)(p_147954_1_ ? 9986 : 9728));
            GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9728);
        }
    }

    private static void setTextureClamped(boolean p_110997_0_) {
        if (p_110997_0_) {
            GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10496);
            GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10496);
        } else {
            GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10497);
            GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10497);
        }
    }

    private static void copyToBuffer(int[] p_110990_0_, int p_110990_1_) {
        ThreadDownloadImageData.copyToBufferPos(p_110990_0_, 0, p_110990_1_);
    }

    private static void copyToBufferPos(int[] p_110994_0_, int p_110994_1_, int p_110994_2_) {
        int[] aint = p_110994_0_;
        DATA_BUFFER.clear();
        DATA_BUFFER.put(aint, p_110994_1_, p_110994_2_);
        DATA_BUFFER.position(0).limit(p_110994_2_);
    }

    public static IntBuffer createDirectIntBuffer(int capacity) {
        return GLAllocation.func_74524_c((int)(capacity << 2)).asIntBuffer();
    }
}

