/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.BlackFirePacket;
import stepsword.mahoutsukai.networking.DataManagerPacket;
import stepsword.mahoutsukai.networking.EntityPathPacket;
import stepsword.mahoutsukai.networking.GardenPacket;
import stepsword.mahoutsukai.networking.InsightPacket;
import stepsword.mahoutsukai.networking.PlayerMahouPacket;
import stepsword.mahoutsukai.networking.PossessEntityPacket;
import stepsword.mahoutsukai.networking.RevertedPacket;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.render.overlay.RenderInsightOverlay;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ClientPacketHandler {
    public static void mahouPacketHandler(PlayerMahouPacket message) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_212871_a_(() -> {
            ClientPlayerEntity player = mc.field_71439_g;
            if (player != null) {
                IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
                IMahou mahouUpdate = message.mahou;
                if (mahou != null) {
                    mahou.copyMahou(mahouUpdate);
                }
            }
        });
    }

    public static void updateTE(DataManagerPacket message) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_212871_a_(() -> {
            TileEntity te = mc.field_71441_e.func_175625_s(message.pos);
            if (te instanceof ScryingMahoujinTileEntity) {
                ((ScryingMahoujinTileEntity)te).scryDataManager = message.dataManagerEntries;
            }
        });
    }

    public static void updateFire(BlackFirePacket message) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.onFire) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BLACK_BURNING, false, 180);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.BLACK_BURNING);
            }
        }
    }

    public static void pathHandler(EntityPathPacket message) {
        try {
            if (ClairvoyanceEyesPotion.predictionMap == null) {
                ClairvoyanceEyesPotion.predictionMap = new ConcurrentHashMap();
            }
            Minecraft mc = Minecraft.func_71410_x();
            int range = MTConfig.CLAIRVOYANCE_RANGE;
            ClientPlayerEntity player = mc.field_71439_g;
            AxisAlignedBB aabb = new AxisAlignedBB(player.func_180425_c().func_177982_a(-range, -range, -range), player.func_180425_c().func_177982_a(range, range, range));
            List lst = mc.field_71441_e.func_217357_a(CreatureEntity.class, aabb);
            HashSet nearby = new HashSet(lst);
            HashSet<CreatureEntity> received = new HashSet<CreatureEntity>();
            for (int i = 0; i < message.entities.size(); ++i) {
                Entity e = player.field_70170_p.func_73045_a(message.entities.get(i).intValue());
                if (!(e instanceof CreatureEntity)) continue;
                CreatureEntity living = (CreatureEntity)e;
                received.add(living);
                if (!nearby.contains(living) || i >= message.paths.size()) continue;
                Path path = message.paths.get(i);
                if (ClairvoyanceEyesPotion.predictionMap == null) continue;
                if (ClairvoyanceEyesPotion.predictionMap.containsKey(living)) {
                    Path p = ClairvoyanceEyesPotion.predictionMap.get(living);
                    if (p.func_75877_a(p.func_75874_d() - 1).equals((Object)path.func_75877_a(path.func_75874_d() - 1))) continue;
                    ClairvoyanceEyesPotion.predictionMap.put(living, path);
                    continue;
                }
                ClairvoyanceEyesPotion.predictionMap.put(living, path);
            }
            if (ClairvoyanceEyesPotion.predictionMap != null) {
                for (Entity e : ClairvoyanceEyesPotion.predictionMap.keySet()) {
                    if (nearby.contains(e) && received.contains(e)) continue;
                    ClairvoyanceEyesPotion.predictionMap.remove(e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateReverted(RevertedPacket message) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.reverted) {
                ReversionEyesPotion.setEntityReverted((LivingEntity)e);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.REVERTED);
            }
        }
    }

    public static void gardenHandler(GardenPacket message) {
        FamiliarEntity.gardenEffectB(new BlockPos(message.posX, message.posY, message.posZ), (World)Minecraft.func_71410_x().field_71441_e);
    }

    public static void possess(PossessEntityPacket message) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            ChunkPos pos = new ChunkPos(message.chunkx, message.chunkz);
            List lst = player.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(pos.func_180331_a(0, 0, 0), pos.func_180331_a(16, 255, 16)));
            for (Entity entity : lst) {
                if (entity.func_145782_y() != message.entityId) continue;
                mc.func_175607_a(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleBakuretsu(BakuretsuPacket message) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Bakuretsu bakuretsu = new Bakuretsu(message.strength, (float)message.posX, (float)message.posY, (float)message.posZ, 0.0f);
        bakuretsu.explosionB((World)Minecraft.func_71410_x().field_71441_e, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        double motionX = player.func_213322_ci().field_72450_a;
        double motionY = player.func_213322_ci().field_72448_b;
        double motionZ = player.func_213322_ci().field_72449_c;
        player.func_213293_j(motionX += (double)message.motionX, motionY += (double)message.motionY, motionZ += (double)message.motionZ);
    }

    public static void insightHandler(InsightPacket message) {
        RenderInsightOverlay.inventory = InsightEyesPotion.readInventory(message.inventory);
        RenderInsightOverlay.entityId = message.id;
        RenderInsightOverlay.hasTarget = message.hasTarget;
        RenderInsightOverlay.block = message.block;
        RenderInsightOverlay.effects = InsightEyesPotion.readEffects(message.effects);
        RenderInsightOverlay.mainhandindex = message.mainhandindex;
    }
}

