/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkInheritedPaneBlock;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.tweaks.block.DirtyGlassBlock;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class GlassShardModule
extends Module {
    public static QuarkBlock dirtyGlass;
    public static Tag<Item> shardTag;
    public static Item clearShard;
    public static Item dirtyShard;
    private static final Map<DyeColor, Item> shardColors;

    @Override
    public void construct() {
        dirtyGlass = new DirtyGlassBlock("dirty_glass", this, ItemGroup.field_78031_c, Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f));
        new QuarkInheritedPaneBlock(dirtyGlass);
        clearShard = new QuarkItem("clear_shard", this, new Item.Properties().func_200916_a(ItemGroup.field_78035_l));
        dirtyShard = new QuarkItem("dirty_shard", this, new Item.Properties().func_200916_a(ItemGroup.field_78035_l));
        for (DyeColor color : DyeColor.values()) {
            shardColors.put(color, (Item)new QuarkItem(color.func_176610_l() + "_shard", this, new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
        }
    }

    @Override
    public void setup() {
        shardTag = new ItemTags.Wrapper(new ResourceLocation("quark", "shards"));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        Block block = event.getState().func_177230_c();
        if (event.getDrops() != null && event.getDrops().isEmpty() && !event.isSilkTouching()) {
            Item item = null;
            if (block == Blocks.field_150359_w) {
                item = clearShard;
            } else if (block == dirtyGlass) {
                item = dirtyShard;
            } else if (block instanceof StainedGlassBlock) {
                item = shardColors.get(((StainedGlassBlock)block).func_196457_d());
            }
            if (item == null) {
                return;
            }
            Random rand = event.getWorld().func_201674_k();
            int quantity = MathHelper.func_76125_a((int)(2 + rand.nextInt(3) + rand.nextInt(event.getFortuneLevel() + 1)), (int)1, (int)4);
            event.getDrops().add(new ItemStack((IItemProvider)item, quantity));
        }
    }

    static {
        shardColors = new HashMap<DyeColor, Item>();
    }
}

