/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.logic.FilterType;

public interface IItemFilter {
    public boolean test(ItemStack var1);

    public boolean isMatchingAmount();

    public void setMatchingAmount(boolean var1);

    public void extractFromInventory(IItemHandler var1, List<ItemStack> var2, boolean var3);

    public void extractFromInventory(IItemHandler var1, BiConsumer<ItemStack, Integer> var2);

    public FilterType getType();

    public void setType(FilterType var1);

    public void read(CompoundNBT var1);

    public void write(CompoundNBT var1);

    default public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        this.write(tag);
        return tag;
    }

    public int limitFlowRate(ItemStack var1, int var2);

    public int getTypeID();

    public static final class ItemFilters {
        private static final Int2ObjectMap<Function<CompoundNBT, IItemFilter>> deserializers = new Int2ObjectOpenHashMap();
        private static int nextID = 0;

        private ItemFilters() {
        }

        public static int allocateID(Function<CompoundNBT, IItemFilter> deserializer) {
            int id = nextID++;
            deserializers.put(id, deserializer);
            return id;
        }

        @Nullable
        public static Function<CompoundNBT, IItemFilter> getDeserializerFor(int typeID) {
            return (Function)deserializers.get(typeID);
        }
    }
}

