/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.StevesFactoryManagerAPI;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.IProcedureType;

public abstract class AbstractProcedure
implements IProcedure,
IClientDataStorage {
    private IProcedureType<?> type;
    private transient Connection[] successors;
    private transient Connection[] predecessors;
    private int componentX;
    private int componentY;
    private String name;
    private String group = "";

    public AbstractProcedure(IProcedureType<?> type) {
        this(type, 1, 1);
    }

    public AbstractProcedure(IProcedureType<?> type, int possibleParents, int possibleChildren) {
        this.type = type;
        this.successors = new Connection[possibleChildren];
        this.predecessors = new Connection[possibleParents];
    }

    @Override
    public boolean isValid() {
        return this.successors != null && this.predecessors != null;
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        this.onPreInvalidate();
        for (Connection predecessor : this.predecessors) {
            if (predecessor == null) continue;
            predecessor.remove();
        }
        for (Connection successor : this.successors) {
            if (successor == null) continue;
            successor.remove();
        }
        this.successors = null;
        this.predecessors = null;
        this.onPostInvalidate();
    }

    protected void onPreInvalidate() {
    }

    protected void onPostInvalidate() {
    }

    @Override
    public Connection[] successors() {
        return this.successors;
    }

    @Override
    public Connection[] predecessors() {
        return this.predecessors;
    }

    @Override
    public void setInputConnection(@Nonnull Connection connection, int index) {
        this.predecessors[index] = connection;
    }

    @Override
    public void setOutputConnection(@Nonnull Connection connection, int index) {
        this.successors[index] = connection;
    }

    @Override
    public Connection removeInputConnection(int index) {
        Connection prev = this.predecessors[index];
        this.predecessors[index] = null;
        return prev;
    }

    @Override
    public Connection removeOutputConnection(int index) {
        Connection prev = this.successors[index];
        this.successors[index] = null;
        return prev;
    }

    @Override
    public IProcedureType<?> getType() {
        return this.type;
    }

    @Override
    public int getComponentX() {
        return this.componentX;
    }

    @Override
    public void setComponentX(int componentX) {
        this.componentX = componentX;
    }

    @Override
    public int getComponentY() {
        return this.componentY;
    }

    @Override
    public void setComponentY(int componentY) {
        this.componentY = componentY;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.type.getLocalizedName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("ID", this.getRegistryName().toString());
        tag.func_74768_a("CompX", this.componentX);
        tag.func_74768_a("CompY", this.componentY);
        tag.func_74778_a("Name", this.getName());
        tag.func_74778_a("Group", this.getGroup());
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        Preconditions.checkArgument((AbstractProcedure.readType(tag) == this.type ? 1 : 0) != 0);
        this.componentX = tag.func_74762_e("CompX");
        this.componentY = tag.func_74762_e("CompY");
        this.name = tag.func_74779_i("Name");
        this.group = tag.func_74779_i("Group");
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.type.getRegistryName();
    }

    protected void pushFrame(IExecutionContext context, @Nullable Connection connection) {
        if (connection != null) {
            context.push(connection.getDestination());
        }
    }

    protected void pushFrame(IExecutionContext context, int outputIndex) {
        this.pushFrame(context, this.successors[outputIndex]);
    }

    public static IProcedureType<?> readType(CompoundNBT tag) {
        ResourceLocation id = new ResourceLocation(tag.func_74779_i("ID"));
        return (IProcedureType)StevesFactoryManagerAPI.getProceduresRegistry().getValue(id);
    }
}

