/*
 * Decompiled with CFR 0.152.
 */
package jeresources.collection;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import jeresources.entry.VillagerEntry;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;

public class TradeList
extends LinkedList<Trade> {
    private static final Random r = new Random();
    private VillagerEntry villagerEntry;

    public TradeList(VillagerEntry villagerEntry) {
        this.villagerEntry = villagerEntry;
    }

    public List<ItemStack> getFirstBuyStacks() {
        return this.stream().map(Trade::getMinBuyStack1).collect(Collectors.toList());
    }

    public List<ItemStack> getSecondBuyStacks() {
        return this.stream().map(Trade::getMinBuyStack2).filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
    }

    public List<ItemStack> getSellStacks() {
        return this.stream().map(Trade::getMinSellStack).collect(Collectors.toList());
    }

    public TradeList getSubListSell(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.sellsItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.villagerEntry)));
    }

    public TradeList getSubListBuy(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.buysItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.villagerEntry)));
    }

    public TradeList getFocusedList(IFocus<ItemStack> focus) {
        if (focus == null) {
            return this;
        }
        switch (focus.getMode()) {
            case INPUT: {
                return this.getSubListBuy((ItemStack)focus.getValue());
            }
            case OUTPUT: {
                return this.getSubListSell((ItemStack)focus.getValue());
            }
        }
        return this;
    }

    private void addMerchantRecipe(MerchantOffers merchantOffers, VillagerTrades.ITrade[] trades, Random rand) {
        for (VillagerTrades.ITrade trade : trades) {
            MerchantOffer offer = trade.func_221182_a((Entity)this.villagerEntry.getVillagerEntity(), rand);
            if (offer == null) continue;
            merchantOffers.add((Object)offer);
        }
    }

    public void addITradeList(VillagerTrades.ITrade[] tradeList) {
        int maxSell;
        int minBuy2;
        int maxBuy2;
        int maxBuy1;
        MerchantOffers tempList = new MerchantOffers();
        Random rand = new Random();
        for (int itr = 0; itr < 100; ++itr) {
            this.addMerchantRecipe(tempList, tradeList, rand);
        }
        if (tempList.size() == 0) {
            return;
        }
        ItemStack buy1 = ((MerchantOffer)tempList.get(0)).func_222218_a();
        ItemStack buy2 = ((MerchantOffer)tempList.get(0)).func_222202_c();
        ItemStack sell = ((MerchantOffer)tempList.get(0)).func_222200_d();
        int minBuy1 = maxBuy1 = buy1.func_190916_E();
        if (!buy2.func_190926_b()) {
            minBuy2 = maxBuy2 = buy2.func_190916_E();
        } else {
            maxBuy2 = 1;
            minBuy2 = 1;
        }
        int minSell = maxSell = sell.func_190916_E();
        for (MerchantOffer merchantRecipe : tempList) {
            if (minBuy1 > merchantRecipe.func_222218_a().func_190916_E()) {
                minBuy1 = merchantRecipe.func_222218_a().func_190916_E();
            }
            if (!buy2.func_190926_b() && minBuy2 > merchantRecipe.func_222202_c().func_190916_E()) {
                minBuy2 = merchantRecipe.func_222202_c().func_190916_E();
            }
            if (minSell > merchantRecipe.func_222200_d().func_190916_E()) {
                minSell = merchantRecipe.func_222200_d().func_190916_E();
            }
            if (maxBuy1 < merchantRecipe.func_222218_a().func_190916_E()) {
                maxBuy1 = merchantRecipe.func_222218_a().func_190916_E();
            }
            if (!buy2.func_190926_b() && maxBuy2 < merchantRecipe.func_222202_c().func_190916_E()) {
                maxBuy2 = merchantRecipe.func_222202_c().func_190916_E();
            }
            if (maxSell >= merchantRecipe.func_222200_d().func_190916_E()) continue;
            maxSell = merchantRecipe.func_222200_d().func_190916_E();
        }
        this.add(new Trade(buy1, minBuy1, maxBuy1, buy2, minBuy2, maxBuy2, sell, minSell, maxSell));
    }

    public static class Trade {
        private final ItemStack buy1;
        private final ItemStack buy2;
        private final ItemStack sell;
        private final int minBuy1;
        private final int minBuy2;
        private final int minSell;
        private final int maxBuy1;
        private final int maxBuy2;
        private final int maxSell;

        Trade(ItemStack buy1, int minBuy1, int maxBuy1, ItemStack buy2, int minBuy2, int maxBuy2, ItemStack sell, int minSell, int maxSell) {
            this.buy1 = buy1;
            this.minBuy1 = minBuy1;
            this.maxBuy1 = maxBuy1;
            this.buy2 = buy2;
            this.minBuy2 = minBuy2;
            this.maxBuy2 = maxBuy2;
            this.sell = sell;
            this.minSell = minSell;
            this.maxSell = maxSell;
        }

        public boolean sellsItem(ItemStack itemStack) {
            return this.sell.func_77969_a(itemStack);
        }

        public boolean buysItem(ItemStack itemStack) {
            return this.buy1.func_77969_a(itemStack) || !this.buy2.func_190926_b() && this.buy2.func_77969_a(itemStack);
        }

        public ItemStack getMinBuyStack1() {
            ItemStack minBuyStack = this.buy1.func_77946_l();
            minBuyStack.func_190920_e(this.minBuy1);
            return minBuyStack;
        }

        public ItemStack getMinBuyStack2() {
            if (this.buy2 == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack minBuyStack = this.buy2.func_77946_l();
            minBuyStack.func_190920_e(this.minBuy2);
            return minBuyStack;
        }

        public ItemStack getMinSellStack() {
            ItemStack minSellStack = this.sell.func_77946_l();
            minSellStack.func_190920_e(this.minSell);
            return minSellStack;
        }

        public ItemStack getMaxBuyStack1() {
            ItemStack maxBuyStack = this.buy1.func_77946_l();
            maxBuyStack.func_190920_e(this.maxBuy1);
            return maxBuyStack;
        }

        public ItemStack getMaxBuyStack2() {
            if (this.buy2 == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack maxBuyStack = this.buy2.func_77946_l();
            maxBuyStack.func_190920_e(this.maxBuy2);
            return maxBuyStack;
        }

        public ItemStack getMaxSellStack() {
            ItemStack maxSellStack = this.sell.func_77946_l();
            maxSellStack.func_190920_e(this.maxSell);
            return maxSellStack;
        }

        public String toString() {
            return "Buy1: " + this.buy1 + ", Buy2: " + this.buy2 + ", Sell: " + this.sell;
        }
    }
}

