/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.shapes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.utils.JsonHelper;

public class ShapeRegistry {
    public static final ShapeRegistry INSTANCE = new ShapeRegistry();
    private final List<ExcavateShape> shapeList = new ArrayList<ExcavateShape>();
    private int curShape = 0;

    public void toggleShape() {
        this.curShape = (this.curShape + 1) % (this.shapeList.size() + 1);
    }

    public ExcavateShape getActiveShape() {
        return this.getShapeAt(this.curShape);
    }

    public void setActiveShape(int index) {
        this.curShape = index <= 0 || index > this.shapeList.size() ? 0 : index;
    }

    public List<ExcavateShape> getShapeList() {
        return this.shapeList;
    }

    public ExcavateShape getShapeAt(int index) {
        if (index <= 0 || index > this.shapeList.size()) {
            return null;
        }
        return this.shapeList.get(index - 1);
    }

    public void loadShapes(File file) {
        this.shapeList.clear();
        if (file.exists()) {
            JsonObject json = JsonHelper.ReadFromFile(file);
            JsonArray jary = JsonHelper.GetArray(json, "shapes");
            for (JsonElement je : jary) {
                if (je == null || !je.isJsonObject()) continue;
                ExcavateShape shape = new ExcavateShape();
                shape.readFromJson(je.getAsJsonObject());
                this.shapeList.add(shape);
            }
        } else {
            int j;
            int i;
            ExcavateShape shape = new ExcavateShape();
            shape.setName("1x2");
            shape.setMask(2, 2, true);
            shape.setMask(2, 1, true);
            this.shapeList.add(shape);
            shape = new ExcavateShape();
            shape.setName("3x3");
            for (i = 1; i < 4; ++i) {
                for (j = 1; j < 4; ++j) {
                    shape.setMask(i, j, true);
                }
            }
            this.shapeList.add(shape);
            shape = new ExcavateShape();
            shape.setName("5x5");
            for (i = 0; i < 5; ++i) {
                for (j = 0; j < 5; ++j) {
                    shape.setMask(i, j, true);
                }
            }
            this.shapeList.add(shape);
            this.saveShapes(file);
        }
    }

    public void saveShapes(File file) {
        JsonObject jsonBase = new JsonObject();
        JsonArray jsonList = new JsonArray();
        for (ExcavateShape shape : this.shapeList) {
            jsonList.add((JsonElement)shape.writeToJson(new JsonObject()));
        }
        jsonBase.add("shapes", (JsonElement)jsonList);
        JsonHelper.WriteToFile(file, jsonBase);
    }
}

