/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import com.mojang.brigadier.StringReader;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.TagIngredient;
import org.apache.logging.log4j.Level;

public class BlockEntry {
    public final boolean isWildcard;
    public final ResourceLocation idName;
    public final TagIngredient tagIng;
    public final BlockState state;

    public BlockEntry() {
        this.idName = null;
        this.tagIng = null;
        this.state = null;
        this.isWildcard = true;
    }

    public BlockEntry(@Nonnull ResourceLocation idName) {
        this.idName = idName;
        this.tagIng = null;
        this.state = null;
        this.isWildcard = false;
    }

    public BlockEntry(@Nonnull BlockState blockState) {
        this.idName = blockState.func_177230_c().getRegistryName();
        this.tagIng = null;
        this.state = blockState;
        this.isWildcard = false;
    }

    public BlockEntry(@Nonnull String tagName) {
        this.tagIng = StringUtils.func_151246_b((String)tagName) ? null : new TagIngredient(tagName);
        this.idName = null;
        this.state = null;
        this.isWildcard = false;
    }

    public boolean checkMatch(BlockState blockState) {
        if (blockState == null || blockState.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        if (this.isWildcard) {
            return true;
        }
        if (this.state != null && this.state.equals(blockState)) {
            return true;
        }
        if (this.tagIng != null && this.tagIng.apply(blockState)) {
            return true;
        }
        return this.idName != null && this.idName.equals((Object)blockState.func_177230_c().getRegistryName());
    }

    public static BlockEntry readFromString(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.equalsIgnoreCase("*")) {
            return new BlockEntry();
        }
        String[] split = s.split(":");
        if (split.length <= 1 || split.length > 3) {
            OreExcavation.logger.log(Level.WARN, "Invalid Block Entry format: " + s);
            return null;
        }
        if (split.length == 2) {
            return new BlockEntry(new ResourceLocation(split[0], split[1]));
        }
        if (s.startsWith("tag:")) {
            return new BlockEntry(s.replaceFirst("tag:", ""));
        }
        if (s.startsWith("state:")) {
            BlockStateParser parser = new BlockStateParser(new StringReader(s.replaceFirst("state:", "")), false);
            try {
                parser.func_197243_a(false);
                if (parser.func_197249_b() != null) {
                    return new BlockEntry(parser.func_197249_b());
                }
            }
            catch (Exception e) {
                OreExcavation.logger.log(Level.ERROR, "Unable to parse block state for Block Entry: " + s, (Throwable)e);
            }
        }
        OreExcavation.logger.log(Level.WARN, "Invalid Block Entry format: " + s);
        return null;
    }
}

