/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class ProjectionSpellScroll
extends SpellScroll {
    public static final String MEMORIZED_WEAPON = "MAHOUTSUKAI_MEMORIZED_WEAPON";

    public ProjectionSpellScroll() {
        super("projection");
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.PROJECTION_MANA_COST;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt;
        IScrollMahou scrollMahou;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Item item = stack.func_77973_b();
        if (item instanceof ProjectionSpellScroll && (scrollMahou = Utils.getScrollMahou(stack)) != null && (nbt = scrollMahou.getSpellStorage()) != null && nbt.func_74764_b(MEMORIZED_WEAPON)) {
            CompoundNBT weapon = nbt.func_74775_l(MEMORIZED_WEAPON);
            String s = "";
            Item i = RealityMarbleSpellEffect.getItemFromName(weapon.func_74779_i("id"));
            if (i != null) {
                if (weapon.func_74764_b("tag") && weapon.func_74775_l("tag").func_74764_b("ench")) {
                    s = s + "Enchanted ";
                }
                s = s + i.func_200295_i(stack).func_150261_e();
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + s));
            }
        }
    }

    @Override
    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        IScrollMahou scrollMahou = Utils.getScrollMahou(stack);
        ScrollMahou serverScrollMahou = new ScrollMahou();
        if (nbtt != null) {
            ScrollMahouProvider.MAHOU.getStorage().readNBT(ScrollMahouProvider.MAHOU, (Object)serverScrollMahou, null, (INBT)nbtt);
            if (scrollMahou != null) {
                scrollMahou.setCasterUUID(serverScrollMahou.getCasterUUID());
                scrollMahou.setCasterName(serverScrollMahou.getCasterName());
                scrollMahou.setSpellStorage(serverScrollMahou.getSpellStorage());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    @Override
    public boolean doSpell(PlayerEntity user, IScrollMahou scrollMahou) {
        if (scrollMahou != null) {
            CompoundNBT spellStorage = scrollMahou.getSpellStorage();
            if (spellStorage == null || !spellStorage.func_74764_b(MEMORIZED_WEAPON)) {
                CompoundNBT memorized = ProjectionSpellEffect.memorize(user);
                if (memorized != null) {
                    user.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Memorized!"));
                    spellStorage = new CompoundNBT();
                    spellStorage.func_218657_a(MEMORIZED_WEAPON, (INBT)memorized);
                    scrollMahou.setSpellStorage(spellStorage);
                    ((ServerPlayerEntity)user).field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(user.field_71071_by.field_70461_c));
                }
            } else {
                return ProjectionSpellEffect.projection(user, spellStorage.func_74775_l(MEMORIZED_WEAPON));
            }
        }
        return false;
    }
}

