/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.network.play.server.SCameraPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCloseWindowPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SMerchantOffersPacket;
import net.minecraft.network.play.server.SOpenBookWindowPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SOpenSignMenuPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerLookPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SSendResourcePackPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.network.play.server.SWindowItemsPacket;
import net.minecraft.network.play.server.SWindowPropertyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ServerCooldownTracker;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayerEntity
extends PlayerEntity
implements IContainerListener {
    private static final Logger field_147102_bM = LogManager.getLogger();
    private String field_71148_cg = "en_US";
    public ServerPlayNetHandler field_71135_a;
    public final MinecraftServer field_71133_b;
    public final PlayerInteractionManager field_71134_c;
    private final List<Integer> field_71130_g = Lists.newLinkedList();
    private final PlayerAdvancements field_192042_bX;
    private final ServerStatisticsManager field_147103_bO;
    private float field_130068_bO = Float.MIN_VALUE;
    private int field_184852_bV = Integer.MIN_VALUE;
    private int field_184853_bW = Integer.MIN_VALUE;
    private int field_184854_bX = Integer.MIN_VALUE;
    private int field_184855_bY = Integer.MIN_VALUE;
    private int field_184856_bZ = Integer.MIN_VALUE;
    private float field_71149_ch = -1.0E8f;
    private int field_71146_ci = -99999999;
    private boolean field_71147_cj = true;
    private int field_71144_ck = -99999999;
    private int field_147101_bU = 60;
    private ChatVisibility field_71143_cn;
    private boolean field_71140_co = true;
    private long field_143005_bX = Util.func_211177_b();
    private Entity field_175401_bS;
    private boolean field_184851_cj;
    private boolean field_192040_cp;
    private final ServerRecipeBook field_192041_cq;
    private Vec3d field_193107_ct;
    private int field_193108_cu;
    private boolean field_193109_cv;
    @Nullable
    private Vec3d field_193110_cw;
    private SectionPos field_213851_cv = SectionPos.func_218154_a(0, 0, 0);
    private int field_71139_cq;
    public boolean field_71137_h;
    public int field_71138_i;
    public boolean field_71136_j;

    public ServerPlayerEntity(MinecraftServer minecraftServer, ServerWorld serverWorld, GameProfile gameProfile, PlayerInteractionManager playerInteractionManager) {
        super(serverWorld, gameProfile);
        playerInteractionManager.field_73090_b = this;
        this.field_71134_c = playerInteractionManager;
        this.field_71133_b = minecraftServer;
        this.field_192041_cq = new ServerRecipeBook(minecraftServer.func_199529_aN());
        this.field_147103_bO = minecraftServer.func_184103_al().func_152602_a(this);
        this.field_192042_bX = minecraftServer.func_184103_al().func_192054_h(this);
        this.field_70138_W = 1.0f;
        this.func_205734_a(serverWorld);
    }

    private void func_205734_a(ServerWorld serverWorld) {
        BlockPos blockPos = serverWorld.func_175694_M();
        if (serverWorld.field_73011_w.func_191066_m() && serverWorld.func_72912_H().func_76077_q() != GameType.ADVENTURE) {
            int n = Math.max(0, this.field_71133_b.func_184108_a(serverWorld));
            \u2603 = MathHelper.func_76128_c(serverWorld.func_175723_af().func_177729_b(blockPos.func_177958_n(), blockPos.func_177952_p()));
            if (\u2603 < n) {
                n = \u2603;
            }
            if (\u2603 <= 1) {
                n = 1;
            }
            \u2603 = (\u2603 = (\u2603 = (long)(n * 2 + 1)) * \u2603) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)\u2603;
            \u2603 = this.func_205735_q(\u2603);
            \u2603 = new Random().nextInt(\u2603);
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u2603 = (\u2603 + \u2603 * \u2603) % \u2603;
                \u2603 = \u2603 % (n * 2 + 1);
                \u2603 = \u2603 / (n * 2 + 1);
                BlockPos blockPos2 = serverWorld.func_201675_m().func_206921_a(blockPos.func_177958_n() + \u2603 - n, blockPos.func_177952_p() + \u2603 - n, false);
                if (blockPos2 == null) continue;
                this.func_174828_a(blockPos2, 0.0f, 0.0f);
                if (!serverWorld.func_226669_j_(this)) {
                    continue;
                }
                break;
            }
        } else {
            this.func_174828_a(blockPos, 0.0f, 0.0f);
            while (!serverWorld.func_226669_j_(this) && this.func_226278_cu_() < 255.0) {
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
            }
        }
    }

    private int func_205735_q(int n) {
        return n <= 16 ? n - 1 : 17;
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("playerGameType", 99)) {
            if (this.func_184102_h().func_104056_am()) {
                this.field_71134_c.func_73076_a(this.func_184102_h().func_71265_f());
            } else {
                this.field_71134_c.func_73076_a(GameType.func_77146_a(compoundNBT.func_74762_e("playerGameType")));
            }
        }
        if (compoundNBT.func_150297_b("enteredNetherPosition", 10)) {
            \u2603 = compoundNBT.func_74775_l("enteredNetherPosition");
            this.field_193110_cw = new Vec3d(\u2603.func_74769_h("x"), \u2603.func_74769_h("y"), \u2603.func_74769_h("z"));
        }
        this.field_192040_cp = compoundNBT.func_74767_n("seenCredits");
        if (compoundNBT.func_150297_b("recipeBook", 10)) {
            this.field_192041_cq.func_192825_a(compoundNBT.func_74775_l("recipeBook"));
        }
        if (this.func_70608_bn()) {
            this.func_213366_dy();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        Object object;
        super.func_213281_b(compoundNBT2);
        compoundNBT2.func_74768_a("playerGameType", this.field_71134_c.func_73081_b().func_77148_a());
        compoundNBT2.func_74757_a("seenCredits", this.field_192040_cp);
        if (this.field_193110_cw != null) {
            object = new CompoundNBT();
            ((CompoundNBT)object).func_74780_a("x", this.field_193110_cw.field_72450_a);
            ((CompoundNBT)object).func_74780_a("y", this.field_193110_cw.field_72448_b);
            ((CompoundNBT)object).func_74780_a("z", this.field_193110_cw.field_72449_c);
            compoundNBT2.func_218657_a("enteredNetherPosition", (INBT)object);
        }
        object = this.func_184208_bv();
        Entity \u26032 = this.func_184187_bx();
        if (\u26032 != null && object != this && ((Entity)object).func_200601_bK()) {
            CompoundNBT compoundNBT3 = new CompoundNBT();
            \u2603 = new CompoundNBT();
            ((Entity)object).func_70039_c(\u2603);
            compoundNBT3.func_186854_a("Attach", \u26032.func_110124_au());
            compoundNBT3.func_218657_a("Entity", \u2603);
            compoundNBT2.func_218657_a("RootVehicle", compoundNBT3);
        }
        compoundNBT2.func_218657_a("recipeBook", this.field_192041_cq.func_192824_e());
    }

    public void func_195394_a(int n) {
        float f = this.func_71050_bK();
        \u2603 = (f - 1.0f) / f;
        this.field_71106_cc = MathHelper.func_76131_a((float)n / f, 0.0f, \u2603);
        this.field_71144_ck = -1;
    }

    public void func_195399_b(int n) {
        this.field_71068_ca = n;
        this.field_71144_ck = -1;
    }

    @Override
    public void func_82242_a(int n) {
        super.func_82242_a(n);
        this.field_71144_ck = -1;
    }

    @Override
    public void func_192024_a(ItemStack itemStack, int n) {
        super.func_192024_a(itemStack, n);
        this.field_71144_ck = -1;
    }

    public void func_71116_b() {
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_152111_bt() {
        super.func_152111_bt();
        this.field_71135_a.func_147359_a(new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTER_COMBAT));
    }

    @Override
    public void func_152112_bu() {
        super.func_152112_bu();
        this.field_71135_a.func_147359_a(new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.END_COMBAT));
    }

    @Override
    protected void func_191955_a(BlockState blockState) {
        CriteriaTriggers.field_192124_d.func_192193_a(this, blockState);
    }

    @Override
    protected CooldownTracker func_184815_l() {
        return new ServerCooldownTracker(this);
    }

    @Override
    public void func_70071_h_() {
        this.field_71134_c.func_73075_a();
        --this.field_147101_bU;
        if (this.field_70172_ad > 0) {
            --this.field_70172_ad;
        }
        this.field_71070_bA.func_75142_b();
        if (!this.field_70170_p.field_72995_K && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        while (!this.field_71130_g.isEmpty()) {
            int n = Math.min(this.field_71130_g.size(), Integer.MAX_VALUE);
            int[] \u26032 = new int[n];
            Iterator<Integer> \u26033 = this.field_71130_g.iterator();
            \u2603 = 0;
            while (\u26033.hasNext() && \u2603 < n) {
                \u26032[\u2603++] = \u26033.next();
                \u26033.remove();
            }
            this.field_71135_a.func_147359_a(new SDestroyEntitiesPacket(\u26032));
        }
        Entity entity = this.func_175398_C();
        if (entity != this) {
            if (entity.func_70089_S()) {
                this.func_70080_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                this.func_71121_q().func_72863_F().func_217221_a(this);
                if (this.func_226564_dU_()) {
                    this.func_175399_e(this);
                }
            } else {
                this.func_175399_e(this);
            }
        }
        CriteriaTriggers.field_193135_v.func_193182_a(this);
        if (this.field_193107_ct != null) {
            CriteriaTriggers.field_193133_t.func_193162_a(this, this.field_193107_ct, this.field_70173_aa - this.field_193108_cu);
        }
        this.field_192042_bX.func_192741_b(this);
    }

    public void func_71127_g() {
        try {
            if (!this.func_175149_v() || this.field_70170_p.func_175667_e(new BlockPos(this))) {
                super.func_70071_h_();
            }
            for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = this.field_71071_by.func_70301_a(i);
                if (!itemStack.func_77973_b().func_77643_m_() || (\u2603 = ((AbstractMapItem)itemStack.func_77973_b()).func_150911_c(itemStack, this.field_70170_p, this)) == null) continue;
                this.field_71135_a.func_147359_a(\u2603);
            }
            if (this.func_110143_aJ() != this.field_71149_ch || this.field_71146_ci != this.field_71100_bB.func_75116_a() || this.field_71100_bB.func_75115_e() == 0.0f != this.field_71147_cj) {
                this.field_71135_a.func_147359_a(new SUpdateHealthPacket(this.func_110143_aJ(), this.field_71100_bB.func_75116_a(), this.field_71100_bB.func_75115_e()));
                this.field_71149_ch = this.func_110143_aJ();
                this.field_71146_ci = this.field_71100_bB.func_75116_a();
                boolean bl = this.field_71147_cj = this.field_71100_bB.func_75115_e() == 0.0f;
            }
            if (this.func_110143_aJ() + this.func_110139_bj() != this.field_130068_bO) {
                this.field_130068_bO = this.func_110143_aJ() + this.func_110139_bj();
                this.func_184849_a(ScoreCriteria.field_96638_f, MathHelper.func_76123_f(this.field_130068_bO));
            }
            if (this.field_71100_bB.func_75116_a() != this.field_184852_bV) {
                this.field_184852_bV = this.field_71100_bB.func_75116_a();
                this.func_184849_a(ScoreCriteria.field_186698_h, MathHelper.func_76123_f(this.field_184852_bV));
            }
            if (this.func_70086_ai() != this.field_184853_bW) {
                this.field_184853_bW = this.func_70086_ai();
                this.func_184849_a(ScoreCriteria.field_186699_i, MathHelper.func_76123_f(this.field_184853_bW));
            }
            if (this.func_70658_aO() != this.field_184854_bX) {
                this.field_184854_bX = this.func_70658_aO();
                this.func_184849_a(ScoreCriteria.field_186700_j, MathHelper.func_76123_f(this.field_184854_bX));
            }
            if (this.field_71067_cb != this.field_184856_bZ) {
                this.field_184856_bZ = this.field_71067_cb;
                this.func_184849_a(ScoreCriteria.field_186701_k, MathHelper.func_76123_f(this.field_184856_bZ));
            }
            if (this.field_71068_ca != this.field_184855_bY) {
                this.field_184855_bY = this.field_71068_ca;
                this.func_184849_a(ScoreCriteria.field_186702_l, MathHelper.func_76123_f(this.field_184855_bY));
            }
            if (this.field_71067_cb != this.field_71144_ck) {
                this.field_71144_ck = this.field_71067_cb;
                this.field_71135_a.func_147359_a(new SSetExperiencePacket(this.field_71106_cc, this.field_71067_cb, this.field_71068_ca));
            }
            if (this.field_70173_aa % 20 == 0) {
                CriteriaTriggers.field_192135_o.func_192215_a(this);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking player");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Player being ticked");
            this.func_85029_a(\u26032);
            throw new ReportedException(crashReport);
        }
    }

    private void func_184849_a(ScoreCriteria scoreCriteria, int n) {
        this.func_96123_co().func_197893_a(scoreCriteria, this.func_195047_I_(), score -> score.func_96647_c(n));
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        boolean bl = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l);
        if (bl) {
            Object object = this.func_110142_aN().func_151521_b();
            this.field_71135_a.func_211148_a(new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, (ITextComponent)object), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)arg_0 -> this.func_212356_a((ITextComponent)object, arg_0)));
            Team \u26032 = this.func_96124_cp();
            if (\u26032 == null || \u26032.func_178771_j() == Team.Visible.ALWAYS) {
                this.field_71133_b.func_184103_al().func_148539_a((ITextComponent)object);
            } else if (\u26032.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                this.field_71133_b.func_184103_al().func_177453_a(this, (ITextComponent)object);
            } else if (\u26032.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                this.field_71133_b.func_184103_al().func_177452_b(this, (ITextComponent)object);
            }
        } else {
            this.field_71135_a.func_147359_a(new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        if (!this.func_175149_v()) {
            this.func_213345_d(damageSource);
        }
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        object = this.func_94060_bK();
        if (object != null) {
            this.func_71029_a(Stats.field_199091_i.func_199076_b(((Entity)object).func_200600_R()));
            ((Entity)object).func_191956_a(this, this.field_70744_aE, damageSource);
            this.func_226298_f_((LivingEntity)object);
        }
        this.field_70170_p.func_72960_a(this, (byte)3);
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    @Override
    public void func_191956_a(Entity entity, int n, DamageSource damageSource) {
        if (entity == this) {
            return;
        }
        super.func_191956_a(entity, n, damageSource);
        this.func_85039_t(n);
        String string = this.func_195047_I_();
        \u2603 = entity.func_195047_I_();
        this.func_96123_co().func_197893_a(ScoreCriteria.field_96640_e, string, Score::func_96648_a);
        if (entity instanceof PlayerEntity) {
            this.func_195066_a(Stats.field_75932_A);
            this.func_96123_co().func_197893_a(ScoreCriteria.field_96639_d, string, Score::func_96648_a);
        } else {
            this.func_195066_a(Stats.field_188070_B);
        }
        this.func_195398_a(string, \u2603, ScoreCriteria.field_197913_m);
        this.func_195398_a(\u2603, string, ScoreCriteria.field_197914_n);
        CriteriaTriggers.field_192122_b.func_192211_a(this, entity, damageSource);
    }

    private void func_195398_a(String string, String string2, ScoreCriteria[] scoreCriteriaArray) {
        ScorePlayerTeam scorePlayerTeam = this.func_96123_co().func_96509_i(string2);
        if (scorePlayerTeam != null && (\u2603 = scorePlayerTeam.func_178775_l().func_175746_b()) >= 0 && \u2603 < scoreCriteriaArray.length) {
            this.func_96123_co().func_197893_a(scoreCriteriaArray[\u2603], string, Score::func_96648_a);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        boolean bl = \u2603 = this.field_71133_b.func_71262_S() && this.func_175400_cq() && "fall".equals(damageSource2.field_76373_n);
        if (!\u2603 && this.field_147101_bU > 0 && damageSource2 != DamageSource.field_76380_i) {
            return false;
        }
        if (damageSource2 instanceof EntityDamageSource) {
            Entity entity = damageSource2.func_76346_g();
            if (entity instanceof PlayerEntity && !this.func_96122_a((PlayerEntity)entity)) {
                return false;
            }
            if (entity instanceof AbstractArrowEntity && (\u2603 = (\u2603 = (AbstractArrowEntity)entity).func_212360_k()) instanceof PlayerEntity && !this.func_96122_a((PlayerEntity)\u2603)) {
                return false;
            }
        }
        return super.func_70097_a(damageSource2, f);
    }

    @Override
    public boolean func_96122_a(PlayerEntity playerEntity) {
        if (!this.func_175400_cq()) {
            return false;
        }
        return super.func_96122_a(playerEntity);
    }

    private boolean func_175400_cq() {
        return this.field_71133_b.func_71219_W();
    }

    @Override
    @Nullable
    public Entity func_212321_a(DimensionType dimensionType) {
        ServerWorld serverWorld;
        this.field_184851_cj = true;
        \u2603 = this.field_71093_bK;
        if (\u2603 == DimensionType.field_223229_c_ && dimensionType == DimensionType.field_223227_a_) {
            this.func_213319_R();
            this.func_71121_q().func_217434_e(this);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a(new SChangeGameStatePacket(4, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return this;
        }
        ServerWorld serverWorld2 = this.field_71133_b.func_71218_a(\u2603);
        this.field_71093_bK = dimensionType;
        serverWorld = this.field_71133_b.func_71218_a(dimensionType);
        WorldInfo \u26032 = serverWorld.func_72912_H();
        this.field_71135_a.func_147359_a(new SRespawnPacket(dimensionType, WorldInfo.func_227498_c_(\u26032.func_76063_b()), \u26032.func_76067_t(), this.field_71134_c.func_73081_b()));
        this.field_71135_a.func_147359_a(new SServerDifficultyPacket(\u26032.func_176130_y(), \u26032.func_176123_z()));
        PlayerList \u26033 = this.field_71133_b.func_184103_al();
        \u26033.func_187243_f(this);
        serverWorld2.func_217434_e(this);
        this.field_70128_L = false;
        double \u26034 = this.func_226277_ct_();
        double \u26035 = this.func_226278_cu_();
        double \u26036 = this.func_226281_cx_();
        float \u26037 = this.field_70125_A;
        float \u26038 = this.field_70177_z;
        double \u26039 = 8.0;
        float \u260310 = \u26038;
        serverWorld2.func_217381_Z().func_76320_a("moving");
        if (\u2603 == DimensionType.field_223227_a_ && dimensionType == DimensionType.field_223228_b_) {
            this.field_193110_cw = this.func_213303_ch();
            \u26034 /= 8.0;
            \u26036 /= 8.0;
        } else if (\u2603 == DimensionType.field_223228_b_ && dimensionType == DimensionType.field_223227_a_) {
            \u26034 *= 8.0;
            \u26036 *= 8.0;
        } else if (\u2603 == DimensionType.field_223227_a_ && dimensionType == DimensionType.field_223229_c_) {
            BlockPos blockPos = serverWorld.func_180504_m();
            \u26034 = blockPos.func_177958_n();
            \u26035 = blockPos.func_177956_o();
            \u26036 = blockPos.func_177952_p();
            \u26038 = 90.0f;
            \u26037 = 0.0f;
        }
        this.func_70012_b(\u26034, \u26035, \u26036, \u26038, \u26037);
        serverWorld2.func_217381_Z().func_76319_b();
        serverWorld2.func_217381_Z().func_76320_a("placing");
        double \u260311 = Math.min(-2.9999872E7, serverWorld.func_175723_af().func_177726_b() + 16.0);
        double \u260312 = Math.min(-2.9999872E7, serverWorld.func_175723_af().func_177736_c() + 16.0);
        double \u260313 = Math.min(2.9999872E7, serverWorld.func_175723_af().func_177728_d() - 16.0);
        double \u260314 = Math.min(2.9999872E7, serverWorld.func_175723_af().func_177733_e() - 16.0);
        \u26034 = MathHelper.func_151237_a(\u26034, \u260311, \u260313);
        \u26036 = MathHelper.func_151237_a(\u26036, \u260312, \u260314);
        this.func_70012_b(\u26034, \u26035, \u26036, \u26038, \u26037);
        if (dimensionType == DimensionType.field_223229_c_) {
            int n = MathHelper.func_76128_c(this.func_226277_ct_());
            \u2603 = MathHelper.func_76128_c(this.func_226278_cu_()) - 1;
            \u2603 = MathHelper.func_76128_c(this.func_226281_cx_());
            boolean \u260315 = true;
            boolean \u260316 = false;
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                    for (\u2603 = -1; \u2603 < 3; ++\u2603) {
                        \u2603 = n + \u2603 * 1 + \u2603 * 0;
                        \u2603 = \u2603 + \u2603;
                        \u2603 = \u2603 + \u2603 * 0 - \u2603 * 1;
                        boolean bl = \u2603 < 0;
                        serverWorld.func_175656_a(new BlockPos(\u2603, \u2603, \u2603), bl ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            this.func_70012_b(n, \u2603, \u2603, \u26038, 0.0f);
            this.func_213317_d(Vec3d.field_186680_a);
        } else if (!serverWorld.func_85176_s().func_222268_a(this, \u260310)) {
            serverWorld.func_85176_s().func_85188_a(this);
            serverWorld.func_85176_s().func_222268_a(this, \u260310);
        }
        serverWorld2.func_217381_Z().func_76319_b();
        this.func_70029_a(serverWorld);
        serverWorld.func_217447_b(this);
        this.func_213846_b(serverWorld2);
        this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), \u26038, \u26037);
        this.field_71134_c.func_73080_a(serverWorld);
        this.field_71135_a.func_147359_a(new SPlayerAbilitiesPacket(this.field_71075_bZ));
        \u26033.func_72354_b(this, serverWorld);
        \u26033.func_72385_f(this);
        for (EffectInstance effectInstance : this.func_70651_bq()) {
            this.field_71135_a.func_147359_a(new SPlayEntityEffectPacket(this.func_145782_y(), effectInstance));
        }
        this.field_71135_a.func_147359_a(new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        return this;
    }

    private void func_213846_b(ServerWorld serverWorld) {
        DimensionType dimensionType = serverWorld.field_73011_w.func_186058_p();
        \u2603 = this.field_70170_p.field_73011_w.func_186058_p();
        CriteriaTriggers.field_193134_u.func_193143_a(this, dimensionType, \u2603);
        if (dimensionType == DimensionType.field_223228_b_ && \u2603 == DimensionType.field_223227_a_ && this.field_193110_cw != null) {
            CriteriaTriggers.field_193131_B.func_193168_a(this, this.field_193110_cw);
        }
        if (\u2603 != DimensionType.field_223228_b_) {
            this.field_193110_cw = null;
        }
    }

    @Override
    public boolean func_174827_a(ServerPlayerEntity serverPlayerEntity) {
        if (serverPlayerEntity.func_175149_v()) {
            return this.func_175398_C() == this;
        }
        if (this.func_175149_v()) {
            return false;
        }
        return super.func_174827_a(serverPlayerEntity);
    }

    private void func_147097_b(TileEntity tileEntity) {
        if (tileEntity != null && (\u2603 = tileEntity.func_189518_D_()) != null) {
            this.field_71135_a.func_147359_a(\u2603);
        }
    }

    @Override
    public void func_71001_a(Entity entity, int n) {
        super.func_71001_a(entity, n);
        this.field_71070_bA.func_75142_b();
    }

    @Override
    public Either<PlayerEntity.SleepResult, Unit> func_213819_a(BlockPos blockPos) {
        return super.func_213819_a(blockPos).ifRight(unit -> {
            this.func_195066_a(Stats.field_188064_ad);
            CriteriaTriggers.field_192136_p.func_192215_a(this);
        });
    }

    @Override
    public void func_225652_a_(boolean bl, boolean bl2) {
        if (this.func_70608_bn()) {
            this.func_71121_q().func_72863_F().func_217216_a(this, new SAnimateHandPacket(this, 2));
        }
        super.func_225652_a_(bl, bl2);
        if (this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_184205_a(Entity entity, boolean bl) {
        Entity entity2 = this.func_184187_bx();
        if (!super.func_184205_a(entity, bl)) {
            return false;
        }
        \u2603 = this.func_184187_bx();
        if (\u2603 != entity2 && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        \u2603 = this.func_184187_bx();
        if (\u2603 != entity && this.field_71135_a != null) {
            this.field_71135_a.func_147364_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public boolean func_180431_b(DamageSource damageSource) {
        return super.func_180431_b(damageSource) || this.func_184850_K() || this.field_71075_bZ.field_75102_a && damageSource == DamageSource.field_82727_n;
    }

    @Override
    protected void func_184231_a(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    @Override
    protected void func_184594_b(BlockPos blockPos) {
        if (!this.func_175149_v()) {
            super.func_184594_b(blockPos);
        }
    }

    public void func_71122_b(double d, boolean bl) {
        BlockPos blockPos = this.func_226268_ag_();
        if (!this.field_70170_p.func_175667_e(blockPos)) {
            return;
        }
        BlockState \u26032 = this.field_70170_p.func_180495_p(blockPos);
        super.func_184231_a(d, bl, \u26032, blockPos);
    }

    @Override
    public void func_175141_a(SignTileEntity signTileEntity) {
        signTileEntity.func_145912_a(this);
        this.field_71135_a.func_147359_a(new SOpenSignMenuPacket(signTileEntity.func_174877_v()));
    }

    private void func_71117_bO() {
        this.field_71139_cq = this.field_71139_cq % 100 + 1;
    }

    @Override
    public OptionalInt func_213829_a(@Nullable INamedContainerProvider iNamedContainerProvider) {
        if (iNamedContainerProvider == null) {
            return OptionalInt.empty();
        }
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        Container container = iNamedContainerProvider.createMenu(this.field_71139_cq, this.field_71071_by, this);
        if (container == null) {
            if (this.func_175149_v()) {
                this.func_146105_b(new TranslationTextComponent("container.spectatorCantOpen", new Object[0]).func_211708_a(TextFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.field_71135_a.func_147359_a(new SOpenWindowPacket(container.field_75152_c, container.func_216957_a(), iNamedContainerProvider.func_145748_c_()));
        container.func_75132_a(this);
        this.field_71070_bA = container;
        return OptionalInt.of(this.field_71139_cq);
    }

    @Override
    public void func_213818_a(int n, MerchantOffers merchantOffers, int n2, int n3, boolean bl, boolean bl2) {
        this.field_71135_a.func_147359_a(new SMerchantOffersPacket(n, merchantOffers, n2, n3, bl, bl2));
    }

    @Override
    public void func_184826_a(AbstractHorseEntity abstractHorseEntity, IInventory iInventory) {
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.func_71117_bO();
        this.field_71135_a.func_147359_a(new SOpenHorseWindowPacket(this.field_71139_cq, iInventory.func_70302_i_(), abstractHorseEntity.func_145782_y()));
        this.field_71070_bA = new HorseInventoryContainer(this.field_71139_cq, this.field_71071_by, iInventory, abstractHorseEntity);
        this.field_71070_bA.func_75132_a(this);
    }

    @Override
    public void func_184814_a(ItemStack itemStack, Hand hand) {
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151164_bB) {
            if (WrittenBookItem.func_220050_a(itemStack, this.func_195051_bN(), this)) {
                this.field_71070_bA.func_75142_b();
            }
            this.field_71135_a.func_147359_a(new SOpenBookWindowPacket(hand));
        }
    }

    @Override
    public void func_184824_a(CommandBlockTileEntity commandBlockTileEntity) {
        commandBlockTileEntity.func_184252_d(true);
        this.func_147097_b(commandBlockTileEntity);
    }

    @Override
    public void func_71111_a(Container container, int n, ItemStack itemStack) {
        if (container.func_75139_a(n) instanceof CraftingResultSlot) {
            return;
        }
        if (container == this.field_71069_bz) {
            CriteriaTriggers.field_192125_e.func_192208_a(this, this.field_71071_by);
        }
        if (this.field_71137_h) {
            return;
        }
        this.field_71135_a.func_147359_a(new SSetSlotPacket(container.field_75152_c, n, itemStack));
    }

    public void func_71120_a(Container container) {
        this.func_71110_a(container, container.func_75138_a());
    }

    @Override
    public void func_71110_a(Container container, NonNullList<ItemStack> nonNullList) {
        this.field_71135_a.func_147359_a(new SWindowItemsPacket(container.field_75152_c, nonNullList));
        this.field_71135_a.func_147359_a(new SSetSlotPacket(-1, -1, this.field_71071_by.func_70445_o()));
    }

    @Override
    public void func_71112_a(Container container, int n, int n2) {
        this.field_71135_a.func_147359_a(new SWindowPropertyPacket(container.field_75152_c, n, n2));
    }

    @Override
    public void func_71053_j() {
        this.field_71135_a.func_147359_a(new SCloseWindowPacket(this.field_71070_bA.field_75152_c));
        this.func_71128_l();
    }

    public void func_71113_k() {
        if (this.field_71137_h) {
            return;
        }
        this.field_71135_a.func_147359_a(new SSetSlotPacket(-1, -1, this.field_71071_by.func_70445_o()));
    }

    public void func_71128_l() {
        this.field_71070_bA.func_75134_a(this);
        this.field_71070_bA = this.field_71069_bz;
    }

    public void func_110430_a(float f, float f2, boolean bl, boolean bl2) {
        if (this.func_184218_aH()) {
            if (f >= -1.0f && f <= 1.0f) {
                this.field_70702_br = f;
            }
            if (f2 >= -1.0f && f2 <= 1.0f) {
                this.field_191988_bg = f2;
            }
            this.field_70703_bu = bl;
            this.func_226284_e_(bl2);
        }
    }

    @Override
    public void func_71064_a(Stat<?> stat, int n) {
        this.field_147103_bO.func_150871_b(this, stat, n);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), score -> score.func_96649_a(n));
    }

    @Override
    public void func_175145_a(Stat<?> stat) {
        this.field_147103_bO.func_150873_a(this, stat, 0);
        this.func_96123_co().func_197893_a(stat, this.func_195047_I_(), Score::func_197891_c);
    }

    @Override
    public int func_195065_a(Collection<IRecipe<?>> collection) {
        return this.field_192041_cq.func_197926_a(collection, this);
    }

    @Override
    public void func_193102_a(ResourceLocation[] resourceLocationArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (ResourceLocation resourceLocation : resourceLocationArray) {
            this.field_71133_b.func_199529_aN().func_215367_a(resourceLocation).ifPresent(arrayList::add);
        }
        this.func_195065_a(arrayList);
    }

    @Override
    public int func_195069_b(Collection<IRecipe<?>> collection) {
        return this.field_192041_cq.func_197925_b(collection, this);
    }

    @Override
    public void func_195068_e(int n) {
        super.func_195068_e(n);
        this.field_71144_ck = -1;
    }

    public void func_71123_m() {
        this.field_193109_cv = true;
        this.func_184226_ay();
        if (this.func_70608_bn()) {
            this.func_225652_a_(true, false);
        }
    }

    public boolean func_193105_t() {
        return this.field_193109_cv;
    }

    public void func_71118_n() {
        this.field_71149_ch = -1.0E8f;
    }

    @Override
    public void func_146105_b(ITextComponent iTextComponent, boolean bl) {
        this.field_71135_a.func_147359_a(new SChatPacket(iTextComponent, bl ? ChatType.GAME_INFO : ChatType.CHAT));
    }

    @Override
    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr()) {
            this.field_71135_a.func_147359_a(new SEntityStatusPacket(this, 9));
            super.func_71036_o();
        }
    }

    @Override
    public void func_200602_a(EntityAnchorArgument.Type type, Vec3d vec3d) {
        super.func_200602_a(type, vec3d);
        this.field_71135_a.func_147359_a(new SPlayerLookPacket(type, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_200618_a(EntityAnchorArgument.Type type, Entity entity, EntityAnchorArgument.Type type2) {
        Vec3d vec3d = type2.func_201017_a(entity);
        super.func_200602_a(type, vec3d);
        this.field_71135_a.func_147359_a(new SPlayerLookPacket(type, entity, type2));
    }

    public void func_193104_a(ServerPlayerEntity serverPlayerEntity, boolean bl) {
        if (bl) {
            this.field_71071_by.func_70455_b(serverPlayerEntity.field_71071_by);
            this.func_70606_j(serverPlayerEntity.func_110143_aJ());
            this.field_71100_bB = serverPlayerEntity.field_71100_bB;
            this.field_71068_ca = serverPlayerEntity.field_71068_ca;
            this.field_71067_cb = serverPlayerEntity.field_71067_cb;
            this.field_71106_cc = serverPlayerEntity.field_71106_cc;
            this.func_85040_s(serverPlayerEntity.func_71037_bA());
            this.field_181016_an = serverPlayerEntity.field_181016_an;
            this.field_181017_ao = serverPlayerEntity.field_181017_ao;
            this.field_181018_ap = serverPlayerEntity.field_181018_ap;
        } else if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || serverPlayerEntity.func_175149_v()) {
            this.field_71071_by.func_70455_b(serverPlayerEntity.field_71071_by);
            this.field_71068_ca = serverPlayerEntity.field_71068_ca;
            this.field_71067_cb = serverPlayerEntity.field_71067_cb;
            this.field_71106_cc = serverPlayerEntity.field_71106_cc;
            this.func_85040_s(serverPlayerEntity.func_71037_bA());
        }
        this.field_175152_f = serverPlayerEntity.field_175152_f;
        this.field_71078_a = serverPlayerEntity.field_71078_a;
        this.func_184212_Q().func_187227_b(field_184827_bp, serverPlayerEntity.func_184212_Q().func_187225_a(field_184827_bp));
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
        this.field_192041_cq.func_193824_a(serverPlayerEntity.field_192041_cq);
        this.field_71130_g.addAll(serverPlayerEntity.field_71130_g);
        this.field_192040_cp = serverPlayerEntity.field_192040_cp;
        this.field_193110_cw = serverPlayerEntity.field_193110_cw;
        this.func_192029_h(serverPlayerEntity.func_192023_dk());
        this.func_192031_i(serverPlayerEntity.func_192025_dl());
    }

    @Override
    protected void func_70670_a(EffectInstance effectInstance) {
        super.func_70670_a(effectInstance);
        this.field_71135_a.func_147359_a(new SPlayEntityEffectPacket(this.func_145782_y(), effectInstance));
        if (effectInstance.func_188419_a() == Effects.field_188424_y) {
            this.field_193108_cu = this.field_70173_aa;
            this.field_193107_ct = this.func_213303_ch();
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70695_b(EffectInstance effectInstance, boolean bl) {
        super.func_70695_b(effectInstance, bl);
        this.field_71135_a.func_147359_a(new SPlayEntityEffectPacket(this.func_145782_y(), effectInstance));
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    protected void func_70688_c(EffectInstance effectInstance) {
        super.func_70688_c(effectInstance);
        this.field_71135_a.func_147359_a(new SRemoveEntityEffectPacket(this.func_145782_y(), effectInstance.func_188419_a()));
        if (effectInstance.func_188419_a() == Effects.field_188424_y) {
            this.field_193107_ct = null;
        }
        CriteriaTriggers.field_193139_z.func_193153_a(this);
    }

    @Override
    public void func_70634_a(double d, double d2, double d3) {
        this.field_71135_a.func_147364_a(d, d2, d3, this.field_70177_z, this.field_70125_A);
    }

    @Override
    public void func_225653_b_(double d, double d2, double d3) {
        this.field_71135_a.func_147364_a(d, d2, d3, this.field_70177_z, this.field_70125_A);
        this.field_71135_a.func_184342_d();
    }

    @Override
    public void func_71009_b(Entity entity) {
        this.func_71121_q().func_72863_F().func_217216_a(this, new SAnimateHandPacket(entity, 4));
    }

    @Override
    public void func_71047_c(Entity entity) {
        this.func_71121_q().func_72863_F().func_217216_a(this, new SAnimateHandPacket(entity, 5));
    }

    @Override
    public void func_71016_p() {
        if (this.field_71135_a == null) {
            return;
        }
        this.field_71135_a.func_147359_a(new SPlayerAbilitiesPacket(this.field_71075_bZ));
        this.func_175135_B();
    }

    public ServerWorld func_71121_q() {
        return (ServerWorld)this.field_70170_p;
    }

    @Override
    public void func_71033_a(GameType gameType) {
        this.field_71134_c.func_73076_a(gameType);
        this.field_71135_a.func_147359_a(new SChangeGameStatePacket(3, gameType.func_77148_a()));
        if (gameType == GameType.SPECTATOR) {
            this.func_192030_dh();
            this.func_184210_p();
        } else {
            this.func_175399_e(this);
        }
        this.func_71016_p();
        this.func_175136_bO();
    }

    @Override
    public boolean func_175149_v() {
        return this.field_71134_c.func_73081_b() == GameType.SPECTATOR;
    }

    @Override
    public boolean func_184812_l_() {
        return this.field_71134_c.func_73081_b() == GameType.CREATIVE;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent) {
        this.func_195395_a(iTextComponent, ChatType.SYSTEM);
    }

    public void func_195395_a(ITextComponent iTextComponent, ChatType chatType) {
        this.field_71135_a.func_211148_a(new SChatPacket(iTextComponent, chatType), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
            if (!(future.isSuccess() || chatType != ChatType.GAME_INFO && chatType != ChatType.SYSTEM)) {
                int n = 256;
                String \u26032 = iTextComponent.func_212636_a(256);
                ITextComponent \u26033 = new StringTextComponent(\u26032).func_211708_a(TextFormatting.YELLOW);
                this.field_71135_a.func_147359_a(new SChatPacket(new TranslationTextComponent("multiplayer.message_not_delivered", \u26033).func_211708_a(TextFormatting.RED), ChatType.SYSTEM));
            }
        }));
    }

    public String func_71114_r() {
        String string = this.field_71135_a.field_147371_a.func_74430_c().toString();
        string = string.substring(string.indexOf("/") + 1);
        string = string.substring(0, string.indexOf(":"));
        return string;
    }

    public void func_147100_a(CClientSettingsPacket cClientSettingsPacket) {
        this.field_71148_cg = cClientSettingsPacket.func_149524_c();
        this.field_71143_cn = cClientSettingsPacket.func_149523_e();
        this.field_71140_co = cClientSettingsPacket.func_149520_f();
        this.func_184212_Q().func_187227_b(field_184827_bp, (byte)cClientSettingsPacket.func_149521_d());
        this.func_184212_Q().func_187227_b(field_184828_bq, (byte)(cClientSettingsPacket.func_186991_f() != HandSide.LEFT ? 1 : 0));
    }

    public ChatVisibility func_147096_v() {
        return this.field_71143_cn;
    }

    public void func_175397_a(String string, String string2) {
        this.field_71135_a.func_147359_a(new SSendResourcePackPacket(string, string2));
    }

    @Override
    protected int func_184840_I() {
        return this.field_71133_b.func_211833_a(this.func_146103_bH());
    }

    public void func_143004_u() {
        this.field_143005_bX = Util.func_211177_b();
    }

    public ServerStatisticsManager func_147099_x() {
        return this.field_147103_bO;
    }

    public ServerRecipeBook func_192037_E() {
        return this.field_192041_cq;
    }

    public void func_152339_d(Entity entity) {
        if (entity instanceof PlayerEntity) {
            this.field_71135_a.func_147359_a(new SDestroyEntitiesPacket(entity.func_145782_y()));
        } else {
            this.field_71130_g.add(entity.func_145782_y());
        }
    }

    public void func_184848_d(Entity entity) {
        this.field_71130_g.remove((Object)entity.func_145782_y());
    }

    @Override
    protected void func_175135_B() {
        if (this.func_175149_v()) {
            this.func_175133_bi();
            this.func_82142_c(true);
        } else {
            super.func_175135_B();
        }
    }

    public Entity func_175398_C() {
        return this.field_175401_bS == null ? this : this.field_175401_bS;
    }

    public void func_175399_e(Entity entity) {
        \u2603 = this.func_175398_C();
        Entity entity2 = this.field_175401_bS = entity == null ? this : entity;
        if (\u2603 != this.field_175401_bS) {
            this.field_71135_a.func_147359_a(new SCameraPacket(this.field_175401_bS));
            this.func_70634_a(this.field_175401_bS.func_226277_ct_(), this.field_175401_bS.func_226278_cu_(), this.field_175401_bS.func_226281_cx_());
        }
    }

    @Override
    protected void func_184173_H() {
        if (this.field_71088_bW > 0 && !this.field_184851_cj) {
            --this.field_71088_bW;
        }
    }

    @Override
    public void func_71059_n(Entity entity) {
        if (this.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
            this.func_175399_e(entity);
        } else {
            super.func_71059_n(entity);
        }
    }

    public long func_154331_x() {
        return this.field_143005_bX;
    }

    @Nullable
    public ITextComponent func_175396_E() {
        return null;
    }

    @Override
    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        this.func_184821_cY();
    }

    public boolean func_184850_K() {
        return this.field_184851_cj;
    }

    public void func_184846_L() {
        this.field_184851_cj = false;
    }

    public PlayerAdvancements func_192039_O() {
        return this.field_192042_bX;
    }

    public void func_200619_a(ServerWorld serverWorld, double d, double d2, double d3, float f, float f2) {
        this.func_175399_e(this);
        this.func_184210_p();
        if (serverWorld == this.field_70170_p) {
            this.field_71135_a.func_147364_a(d, d2, d3, f, f2);
        } else {
            ServerWorld serverWorld2 = this.func_71121_q();
            this.field_71093_bK = serverWorld.field_73011_w.func_186058_p();
            WorldInfo \u26032 = serverWorld.func_72912_H();
            this.field_71135_a.func_147359_a(new SRespawnPacket(this.field_71093_bK, WorldInfo.func_227498_c_(\u26032.func_76063_b()), \u26032.func_76067_t(), this.field_71134_c.func_73081_b()));
            this.field_71135_a.func_147359_a(new SServerDifficultyPacket(\u26032.func_176130_y(), \u26032.func_176123_z()));
            this.field_71133_b.func_184103_al().func_187243_f(this);
            serverWorld2.func_217434_e(this);
            this.field_70128_L = false;
            this.func_70012_b(d, d2, d3, f, f2);
            this.func_70029_a(serverWorld);
            serverWorld.func_217446_a(this);
            this.func_213846_b(serverWorld2);
            this.field_71135_a.func_147364_a(d, d2, d3, f, f2);
            this.field_71134_c.func_73080_a(serverWorld);
            this.field_71133_b.func_184103_al().func_72354_b(this, serverWorld);
            this.field_71133_b.func_184103_al().func_72385_f(this);
        }
    }

    public void func_213844_a(ChunkPos chunkPos, IPacket<?> iPacket, IPacket<?> iPacket2) {
        this.field_71135_a.func_147359_a(iPacket2);
        this.field_71135_a.func_147359_a(iPacket);
    }

    public void func_213845_a(ChunkPos chunkPos) {
        if (this.func_70089_S()) {
            this.field_71135_a.func_147359_a(new SUnloadChunkPacket(chunkPos.field_77276_a, chunkPos.field_77275_b));
        }
    }

    public SectionPos func_213842_M() {
        return this.field_213851_cv;
    }

    public void func_213850_a(SectionPos sectionPos) {
        this.field_213851_cv = sectionPos;
    }

    @Override
    public void func_213823_a(SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.field_71135_a.func_147359_a(new SPlaySoundEffectPacket(soundEvent, soundCategory, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), f, f2));
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnPlayerPacket(this);
    }

    @Override
    public ItemEntity func_146097_a(ItemStack itemStack, boolean bl, boolean bl2) {
        ItemEntity itemEntity = super.func_146097_a(itemStack, bl, bl2);
        if (itemEntity == null) {
            return null;
        }
        this.field_70170_p.func_217376_c(itemEntity);
        ItemStack \u26032 = itemEntity.func_92059_d();
        if (bl2) {
            if (!\u26032.func_190926_b()) {
                this.func_71064_a(Stats.field_188068_aj.func_199076_b(\u26032.func_77973_b()), itemStack.func_190916_E());
            }
            this.func_195066_a(Stats.field_75952_v);
        }
        return itemEntity;
    }

    private /* synthetic */ void func_212356_a(ITextComponent iTextComponent, Future future) throws Exception {
        if (!future.isSuccess()) {
            int n = 256;
            String \u26032 = iTextComponent.func_212636_a(256);
            TranslationTextComponent \u26033 = new TranslationTextComponent("death.attack.message_too_long", new StringTextComponent(\u26032).func_211708_a(TextFormatting.YELLOW));
            ITextComponent \u26034 = new TranslationTextComponent("death.attack.even_more_magic", this.func_145748_c_()).func_211710_a(style -> style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, \u26033)));
            this.field_71135_a.func_147359_a(new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, \u26034));
        }
    }
}

